/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.container;

import com.infinityraider.agricraft.container.SlotSeedAnalyzerJournal;
import com.infinityraider.agricraft.container.SlotSeedAnalyzerSeed;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.container.ContainerBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerSeedAnalyzer
extends ContainerBase<TileEntitySeedAnalyzer> {
    public int progress;
    public static final int seedSlotId = 36;
    public static final int journalSlotId = 37;

    public ContainerSeedAnalyzer(TileEntitySeedAnalyzer analyzer, InventoryPlayer inventory, SeedAnalyzerLayout layout) {
        super((TileEntity)analyzer, inventory, layout.offsetX, layout.offsetY);
        this.func_75146_a(new SlotSeedAnalyzerSeed((IInventory)this.tile, 36, layout.seedSlotX, layout.seedSlotY));
        this.func_75146_a(new SlotSeedAnalyzerJournal((IInventory)this.tile, 37, layout.journalSlotX, layout.journalSlotY));
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.progress == ((TileEntitySeedAnalyzer)this.tile).getProgress()) continue;
            listener.func_71112_a((Container)this, 0, ((TileEntitySeedAnalyzer)this.tile).getProgress());
        }
        this.progress = ((TileEntitySeedAnalyzer)this.tile).getProgress();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int type, int newValue) {
        if (type == 0) {
            ((TileEntitySeedAnalyzer)this.tile).setProgress(newValue);
        }
    }

    public final boolean hasItem(Slot slot) {
        return slot != null && StackHelper.isValid(slot.func_75211_c());
    }

    public final ItemStack func_82846_b(EntityPlayer player, int clickedSlot) {
        int stop;
        int start;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlot);
        if (!this.hasItem(slot)) {
            return null;
        }
        ItemStack slotStack = slot.func_75211_c();
        ItemStack itemstack = slotStack.func_77946_l();
        if (clickedSlot == 36 || clickedSlot == 37) {
            start = 0;
            stop = this.field_75151_b.size() - 2;
        } else {
            start = 36;
            stop = 38;
        }
        if (this.func_75135_a(slotStack, start, stop, false)) {
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            }
            slot.func_75218_e();
            slot.func_82870_a(player, slotStack);
            return itemstack;
        }
        return null;
    }

    protected final boolean func_75135_a(ItemStack stack, int start, int stop, boolean backwards) {
        if (start < 0 || start >= stop) {
            return false;
        }
        if (!StackHelper.isValid(stack)) {
            return false;
        }
        int delta = backwards ? -1 : 1;
        boolean foundSlot = false;
        if (stack.func_77985_e()) {
            for (int slotIndex = backwards ? stop - 1 : start; slotIndex >= start && slotIndex < stop; slotIndex += delta) {
                Slot slot = (Slot)this.field_75151_b.get(slotIndex);
                ItemStack stackInSlot = slot.func_75211_c();
                if (!slot.func_75214_a(stack) || !StackHelper.areEqual(stack, stackInSlot)) continue;
                int combinedSize = stackInSlot.field_77994_a + stack.field_77994_a;
                if (combinedSize <= stack.func_77976_d()) {
                    stack.field_77994_a = 0;
                    stackInSlot.field_77994_a = combinedSize;
                    slot.func_75218_e();
                    return true;
                }
                if (stackInSlot.field_77994_a >= stack.func_77976_d()) continue;
                stack.field_77994_a = combinedSize - stack.func_77976_d();
                stackInSlot.field_77994_a = stack.func_77976_d();
                slot.func_75218_e();
                foundSlot = true;
            }
        }
        foundSlot = this.addToEmptySlot(stack, start, stop, backwards) | foundSlot;
        return foundSlot;
    }

    public final boolean addToEmptySlot(ItemStack stack, int start, int stop, boolean backwards) {
        int slotIndex;
        if (start < 0 || start >= stop) {
            return false;
        }
        if (!StackHelper.isValid(stack)) {
            return false;
        }
        int delta = backwards ? -1 : 1;
        int n = slotIndex = backwards ? stop - 1 : start;
        while (start <= slotIndex && slotIndex < stop) {
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot == null && slot.func_75214_a(stack)) {
                slot.func_75215_d(stack.func_77946_l());
                slot.func_75218_e();
                stack.field_77994_a = 0;
                return true;
            }
            slotIndex += delta;
        }
        return false;
    }

    public static enum SeedAnalyzerLayout {
        NORMAL(8, 94, 80, 40, 152, 68),
        PERIPHERAL(5, 94, 77, 40, 149, 68);

        public final int offsetX;
        public final int offsetY;
        public final int seedSlotX;
        public final int seedSlotY;
        public final int journalSlotX;
        public final int journalSlotY;

        private SeedAnalyzerLayout(int offsetX, int offsetY, int seedSlotX, int seedSlotY, int journalSlotX, int journalSlotY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.seedSlotX = seedSlotX;
            this.seedSlotY = seedSlotY;
            this.journalSlotX = journalSlotX;
            this.journalSlotY = journalSlotY;
        }
    }
}

