/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.computer.tiles;

import com.infinityraider.agricraft.blocks.BlockCrop;
import com.infinityraider.agricraft.compat.computer.methods.IMethod;
import com.infinityraider.agricraft.compat.computer.methods.MethodAnalyze;
import com.infinityraider.agricraft.compat.computer.methods.MethodException;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetBaseBlock;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetBrightness;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetBrightnessRange;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetCurrentSoil;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetGrowthStage;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetNeededSoil;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetPlant;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetSpecimen;
import com.infinityraider.agricraft.compat.computer.methods.MethodGetStats;
import com.infinityraider.agricraft.compat.computer.methods.MethodHasJournal;
import com.infinityraider.agricraft.compat.computer.methods.MethodHasPlant;
import com.infinityraider.agricraft.compat.computer.methods.MethodIsAnalyzed;
import com.infinityraider.agricraft.compat.computer.methods.MethodIsCrossCrop;
import com.infinityraider.agricraft.compat.computer.methods.MethodIsFertile;
import com.infinityraider.agricraft.compat.computer.methods.MethodIsMature;
import com.infinityraider.agricraft.compat.computer.methods.MethodNeedsBaseBlock;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityPeripheral
extends TileEntitySeedAnalyzer {
    private static IMethod[] methods;
    private boolean mayAnalyze = false;
    @SideOnly(value=Side.CLIENT)
    private int updateCheck;
    @SideOnly(value=Side.CLIENT)
    private HashMap<EnumFacing, Integer> timers;
    @SideOnly(value=Side.CLIENT)
    private HashMap<EnumFacing, Boolean> activeSides;
    public static final EnumFacing[] VALID_DIRECTIONS;
    public static final int MAX = 60;

    public TileEntityPeripheral() {
        this.initMethods();
    }

    @Override
    protected void writeRotatableTileNBT(NBTTagCompound tag) {
        super.writeRotatableTileNBT(tag);
        tag.func_74757_a("agri_flag", this.mayAnalyze);
    }

    @Override
    protected void readRotatableTileNBT(NBTTagCompound tag) {
        super.readRotatableTileNBT(tag);
        this.mayAnalyze = tag.func_74764_b("agri_flag") && tag.func_74767_n("agri_flag");
    }

    private void initMethods() {
        if (methods == null) {
            methods = TileEntityPeripheral.methodList();
        }
    }

    public IMethod[] getMethods() {
        this.initMethods();
        return methods;
    }

    @Override
    public void func_73660_a() {
        if (this.mayAnalyze) {
            if (this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
                super.func_73660_a();
            } else {
                this.reset();
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.updateCheck == 0) {
                this.checkSides();
            }
            for (EnumFacing dir : VALID_DIRECTIONS) {
                int timer = this.timers.get(dir);
                timer = (timer += this.isSideActive(dir) ? 1 : -1) < 0 ? 0 : timer;
                timer = timer > 60 ? 60 : timer;
                this.timers.put(dir, timer);
            }
            this.updateCheck = (this.updateCheck + 1) % 1200;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimer(EnumFacing dir) {
        if (this.updateCheck == 0 || this.timers == null) {
            this.checkSides();
        }
        return this.timers.get(dir);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isSideActive(EnumFacing dir) {
        return this.activeSides.containsKey(dir) && this.activeSides.get(dir) != false;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkSides() {
        for (EnumFacing dir : VALID_DIRECTIONS) {
            this.checkSide(dir);
        }
        this.updateCheck = 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void checkSide(EnumFacing dir) {
        if (this.timers == null) {
            this.timers = new HashMap();
        }
        if (!this.timers.containsKey(dir)) {
            this.timers.put(dir, 0);
        }
        if (this.activeSides == null) {
            this.activeSides = new HashMap();
        }
        this.activeSides.put(dir, this.isCrop(dir));
    }

    private boolean isCrop(EnumFacing dir) {
        return this.field_145850_b.func_180495_p(new BlockPos(this.xCoord() + dir.func_82601_c(), this.yCoord() + dir.func_96559_d(), this.zCoord() + dir.func_82599_e())).func_177230_c() instanceof BlockCrop;
    }

    public void startAnalyzing() {
        if (!this.mayAnalyze && this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
            this.mayAnalyze = true;
            this.markForUpdate();
        }
    }

    @Override
    public void analyze() {
        super.analyze();
        this.reset();
    }

    private void reset() {
        if (this.mayAnalyze) {
            this.mayAnalyze = false;
            this.markForUpdate();
        }
    }

    @Override
    public String func_70005_c_() {
        return "agricraft_peripheral";
    }

    public String[] getAllMethodNames() {
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = methods[i].getName();
        }
        return names;
    }

    public Object[] invokeMethod(IMethod method, Object ... arguments) throws MethodException {
        return method.call(this, this.field_145850_b, this.func_174877_v(), this.getJournal(), arguments);
    }

    private static IMethod[] methodList() {
        return new IMethod[]{new MethodAnalyze(), new MethodGetBaseBlock(), new MethodGetBrightness(), new MethodGetBrightnessRange(), new MethodGetCurrentSoil(), new MethodGetGrowthStage(), new MethodGetNeededSoil(), new MethodGetPlant(), new MethodGetSpecimen(), new MethodGetStats(), new MethodHasJournal(), new MethodHasPlant(), new MethodIsAnalyzed(), new MethodIsCrossCrop(), new MethodIsFertile(), new MethodIsMature(), new MethodNeedsBaseBlock()};
    }

    static {
        VALID_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    }
}

