/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.storage;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderSeedStorage;
import com.infinityraider.agricraft.tiles.storage.TileEntitySeedStorage;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSeedStorage
extends BlockCustomWood<TileEntitySeedStorage> {
    public BlockSeedStorage() {
        super("seed_storage");
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[]{AgriProperties.FACING};
    }

    public TileEntitySeedStorage createNewTileEntity(World world, int meta) {
        return new TileEntitySeedStorage();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)AgriCraft.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> items = super.getDrops(world, pos, state, fortune);
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntitySeedStorage.class).map(t -> t.getInventory()).orElseGet(Collections::emptyList).stream().map(StackHelper::fitToMaxSize).forEach(items::addAll);
        return items;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntitySeedStorage.class);
        if (tile.isPresent()) {
            TileEntitySeedStorage storage = (TileEntitySeedStorage)tile.get();
            state = AgriProperties.FACING.applyToBlockState(state, (Comparable)storage.getOrientation());
        }
        return state;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderSeedStorage getRenderer() {
        return new RenderSeedStorage(this);
    }

    public boolean isEnabled() {
        return !AgriCraftConfig.disableSeedStorage;
    }
}

