/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannel;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderSprinkler;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.infinitylib.block.BlockTileCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockSprinkler
extends BlockTileCustomRenderedBase<TileEntitySprinkler>
implements IRecipeRegister {
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.25, 0.75);

    public BlockSprinkler() {
        super("sprinkler", Material.field_151573_f);
        this.func_149647_a(AgriTabs.TAB_AGRICRAFT);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
    }

    public TileEntitySprinkler createNewTileEntity(World world, int meta) {
        return new TileEntitySprinkler();
    }

    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos.func_177984_a(), TileEntityChannel.class);
        return ((IExtendedBlockState)state).withProperty(AgriProperties.CUSTOM_WOOD_TYPE, (Object)tile.map(TileEntityCustomWood::getMaterial).orElse(CustomWoodTypeRegistry.DEFAULT));
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
            world.func_175713_t(pos);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float f, int i) {
        if (!world.field_72995_K) {
            ItemStack drop = new ItemStack((Block)this, 1);
            BlockSprinkler.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() instanceof BlockWaterChannel;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderSprinkler getRenderer() {
        return new RenderSprinkler(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("agricraft".toLowerCase() + ":" + this.getInternalName());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() instanceof BlockWaterChannel && state.func_177230_c().func_149688_o(state) == Material.field_151579_a;
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return null;
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableIrrigation;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public final IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[]{AgriProperties.CUSTOM_WOOD_TYPE};
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add("A fancy farm decoration.");
        tooltip.add("Not functional, still under development.");
    }

    public void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)AgriBlocks.getInstance().SPRINKLER, 1), new Object[]{" w ", " i ", "bcb", Character.valueOf('w'), "plankWood", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('c'), Items.field_151133_ar}));
    }
}

