/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.api.v1.irrigation.IrrigationConnection;
import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class AbstractBlockWaterChannel<T extends TileEntityChannel>
extends BlockCustomWood<T> {
    public AbstractBlockWaterChannel(String subtype) {
        super("water_channel_" + subtype);
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        return IrrigationConnection.CONNECTIONS;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class);
        if (!tile.isPresent()) {
            return state;
        }
        ((TileEntityChannel)tile.get()).checkConnections();
        IrrigationConnection sides = new IrrigationConnection();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            sides.set(facing, ((TileEntityChannel)tile.get()).getConnectionType(facing));
        }
        return sides.write(state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class).ifPresent(TileEntityChannel::checkConnections);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableIrrigation;
    }
}

