/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks;

import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.infinitylib.block.BlockTileCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCustomWood<T extends TileEntityCustomWood>
extends BlockTileCustomRenderedBase<T> {
    public BlockCustomWood(String internalName) {
        super(internalName, Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(AgriTabs.TAB_AGRICRAFT);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCustomWood) {
            TileEntityCustomWood tileEntity = (TileEntityCustomWood)te;
            tileEntity.setMaterial(stack);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return !player.field_71075_bZ.field_75098_d || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K) {
            List<ItemStack> drops = this.getDrops((IBlockAccess)world, pos, state, fortune);
            for (ItemStack drop : drops) {
                BlockCustomWood.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack drop = new ItemStack((Block)this, 1);
        this.setTag(world, pos, drop);
        drops.add(drop);
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state));
        this.setTag((IBlockAccess)world, pos, stack);
        return stack;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void setTag(IBlockAccess world, BlockPos pos, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCustomWood) {
            TileEntityCustomWood tile = (TileEntityCustomWood)te;
            stack.func_77982_d(tile.getMaterialTag());
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Class<? extends ItemBlockCustomWood> getItemBlockClass() {
        return ItemBlockCustomWood.class;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("agricraft".toLowerCase() + ":" + this.getInternalName());
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCustomWood.class);
        return this.getExtendedCustomWoodState((IExtendedBlockState)state, tile).withProperty(AgriProperties.CUSTOM_WOOD_TYPE, (Object)tile.map(TileEntityCustomWood::getMaterial).orElse(CustomWoodTypeRegistry.DEFAULT));
    }

    protected IExtendedBlockState getExtendedCustomWoodState(IExtendedBlockState state, Optional<T> tile) {
        return state;
    }

    public final IUnlistedProperty[] getUnlistedPropertyArray() {
        List<IUnlistedProperty> list = this.getUnlistedProperties();
        IUnlistedProperty[] props = list.toArray(new IUnlistedProperty[list.size() + 1]);
        props[props.length - 1] = AgriProperties.CUSTOM_WOOD_TYPE;
        return props;
    }

    protected List<IUnlistedProperty> getUnlistedProperties() {
        return Collections.emptyList();
    }
}

