/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.seed;

import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public final class AgriSeed {
    @Nonnull
    private final IAgriPlant plant;
    @Nonnull
    private final IAgriStat stat;

    public AgriSeed(@Nonnull IAgriPlant plant, @Nonnull IAgriStat stat) {
        this.plant = Objects.requireNonNull(plant, "The plant in an AgriSeed may not be null!");
        this.stat = Objects.requireNonNull(stat, "The stat in an AgriSeed may not be null!");
    }

    @Nonnull
    public IAgriPlant getPlant() {
        return this.plant;
    }

    @Nonnull
    public IAgriStat getStat() {
        return this.stat;
    }

    @Nonnull
    public AgriSeed withPlant(@Nonnull IAgriPlant plant) {
        return new AgriSeed(plant, this.stat);
    }

    @Nonnull
    public AgriSeed withStat(@Nonnull IAgriStat stat) {
        return new AgriSeed(this.plant, stat);
    }

    public ItemStack toStack() {
        ItemStack stack = this.plant.getSeed().func_77946_l();
        this.stat.writeToNBT(stack.func_77978_p());
        return stack;
    }

    public ItemStack toStack(int size) {
        ItemStack stack = this.plant.getSeed().func_77946_l();
        this.stat.writeToNBT(stack.func_77978_p());
        stack.field_77994_a = size;
        return stack;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgriSeed) {
            AgriSeed other = (AgriSeed)obj;
            return this.plant.equals(other.plant) && this.stat.equals(other.stat);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.plant);
        hash = 71 * hash + Objects.hashCode(this.stat);
        return hash;
    }
}

