/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AABBMultiBlock
extends MultiBlock {
    private AxisAlignedBB aabb;
    private IBlockState blockState;

    public AABBMultiBlock(Block block, AxisAlignedBB aabb) {
        this.aabb = aabb;
        this.blockState = block.func_176223_P();
        this.buildStates();
    }

    public AxisAlignedBB getBoundingBox() {
        return this.aabb;
    }

    public AxisAlignedBB getRelativeBoundingBox(BlockPos pos, BlockPos origin) {
        pos = pos.func_177973_b((Vec3i)origin);
        return this.aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    @Override
    protected void buildStates() {
        this.states.clear();
        for (BlockPos pos : BlockPosUtils.getAllInBox(this.aabb)) {
            if (this.offset != null) {
                pos = pos.func_177971_a((Vec3i)this.offset);
            }
            this.states.put(pos, new MBlockState(pos, this.blockState));
        }
    }

    @Override
    public void placeBlocks(World world, BlockPos pos, IBlockState state, boolean placeOrigin) {
        MultiBlockComponent mbc = IComponent.getComponent(MultiBlockComponent.class, state.func_177230_c());
        PropertyDirection dp = DirectionalComponent.getProperty(state.func_177230_c());
        this.blockState = state.func_177226_a((IProperty)mbc.getProperty(), (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)dp, (Comparable)EnumFacing.SOUTH);
        this.buildStates();
        super.placeBlocks(world, pos, state, placeOrigin);
    }
}

