/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class UICheckBox
extends UIComponent<UICheckBox>
implements IGuiText<UICheckBox> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontOptions fontOptions = FontOptions.builder().color(0x444444).build();
    private String text;
    private boolean checked;
    private GuiIconProvider cbIconProvider;

    public UICheckBox(MalisisGui gui, String text) {
        super(gui);
        this.setText(text);
        this.shape = new SimpleGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(242, 32, 10, 10), null, gui.getGuiTexture().getIcon(252, 32, 10, 10));
        this.cbIconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(242, 52, 12, 10), gui.getGuiTexture().getIcon(254, 42, 12, 10), gui.getGuiTexture().getIcon(242, 42, 12, 10));
    }

    public UICheckBox(MalisisGui gui) {
        this(gui, null);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UICheckBox setFont(MalisisFont font) {
        this.font = font;
        this.calculateSize();
        return this;
    }

    @Override
    public FontOptions getFontOptions() {
        return this.fontOptions;
    }

    @Override
    public UICheckBox setFontOptions(FontOptions options) {
        this.fontOptions = options;
        this.calculateSize();
        return this;
    }

    public UICheckBox setText(String text) {
        this.text = text;
        this.calculateSize();
        return this;
    }

    public String getText() {
        return this.text;
    }

    private void calculateSize() {
        int w = StringUtils.isEmpty((CharSequence)this.text) ? 0 : (int)this.font.getStringWidth(this.text, this.fontOptions);
        this.setSize(w + 11, 10);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public UICheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        if (this.fireEvent(new CheckEvent(this, !this.checked))) {
            this.checked = !this.checked;
        }
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        if (keyCode == 57 && this.fireEvent(new CheckEvent(this, !this.checked))) {
            this.checked = !this.checked;
        }
        return false;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(10, 10);
        this.shape.setPosition(1, 0);
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glShadeModel((int)7425);
            this.rp.colorMultiplier.set(0xFFFFFF);
            this.rp.alpha.set(80);
            this.rp.useTexture.set(false);
            this.shape.resetState();
            this.shape.setSize(8, 8);
            this.shape.setPosition(2, 1);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            renderer.drawText(this.font, this.text, 14.0f, 2.0f, 0.0f, this.fontOptions);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.checked) {
            if (this.isHovered() && !this.isDisabled()) {
                GL11.glEnable((int)3042);
            }
            this.rp.reset();
            this.shape.resetState();
            this.shape.setSize(12, 10);
            this.rp.iconProvider.set(this.cbIconProvider);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            if (this.isHovered() && !this.isDisabled()) {
                GL11.glDisable((int)3042);
            }
        }
    }

    @Override
    public String getPropertyString() {
        return "text=" + this.text + " | checked=" + this.checked + " | " + super.getPropertyString();
    }

    public static class CheckEvent
    extends ComponentEvent.ValueChange<UICheckBox, Boolean> {
        public CheckEvent(UICheckBox component, boolean checked) {
            super(component, component.isChecked(), checked);
        }

        public boolean isChecked() {
            return (Boolean)this.newValue;
        }
    }
}

