/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import net.malisis.core.block.IBlockComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BooleanComponent
implements IBlockComponent {
    private String name;
    private PropertyBool property;
    private boolean defaultValue;
    private int metaOffset = 0;

    public BooleanComponent(String name, boolean defaultValue, int metaOffset) {
        this.property = PropertyBool.func_177716_a((String)name);
        this.defaultValue = defaultValue;
        this.metaOffset = metaOffset;
    }

    public BooleanComponent(String name, boolean defaultValue) {
        this(name, defaultValue, 0);
    }

    public BooleanComponent(String name) {
        this(name, false, 0);
    }

    public String getName() {
        return this.name;
    }

    public PropertyBool getProperty() {
        return this.property;
    }

    public void setMetaOffset(int metaOffset) {
        this.metaOffset = metaOffset;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(this.defaultValue));
    }

    public boolean get(IBlockAccess world, BlockPos pos) {
        return this.get(world.func_180495_p(pos));
    }

    public boolean get(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)this.getProperty());
    }

    public IBlockState set(World world, BlockPos pos, boolean value) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, this.set(state, value));
        return state;
    }

    public IBlockState set(IBlockState state, boolean value) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(value));
    }

    public boolean invert(World world, BlockPos pos) {
        boolean value = !this.get((IBlockAccess)world, pos);
        this.set(world, pos, value);
        return value;
    }

    public IBlockState invert(IBlockState state) {
        boolean value = !this.get(state);
        return this.set(state, value);
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return this.get(state) ? 1 << this.metaOffset : 0;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return this.set(state, (meta >> this.metaOffset & 1) != 0);
    }
}

