/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.block.IDismantleable;
import cofh.api.item.IToolHammer;
import cofh.asm.relauncher.Implementable;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Implementable(value={"buildcraft.api.tools.IToolWrench", "com.brandon3055.draconicevolution.api.ICrystalBinder"})
public class ItemWrench
extends ItemMulti
implements IInitializer,
IToolHammer {
    public static ItemStack wrenchBasic;

    public ItemWrench() {
        super("thermalfoundation");
        this.setUnlocalizedName("util", "wrench");
        this.func_77637_a(ThermalFoundation.tabCommon);
        this.setHarvestLevel("wrench", 1);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, stack, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        if (ServerHelper.isServerWorld((World)world) && player.func_70093_af() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            ((IDismantleable)block).dismantleBlock(world, pos, state, player, false);
            return EnumActionResult.SUCCESS;
        }
        if (BlockHelper.canRotate((Block)block)) {
            world.func_180501_a(pos, BlockHelper.rotateVanillaBlock((World)world, (IBlockState)state, (BlockPos)pos), 3);
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        if (!player.func_70093_af() && block.rotateBlock(world, pos, side)) {
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 1.0, 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        return true;
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        return true;
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
    }

    public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        ItemStack stack = player.func_184614_ca();
        return true;
    }

    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
    }

    public boolean preInit() {
        wrenchBasic = this.addItem(0, "wrenchBasic");
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)wrenchBasic, (Object[])new Object[]{"I I", " T ", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "ingotTin"}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    static enum Type {
        BASIC,
        ENDER;

    }
}

