/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCore;
import cofh.thermalfoundation.ThermalFoundation;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockFluidCrudeOil
extends BlockFluidCore {
    public static final int LEVELS = 6;
    public static final Material materialFluidCrudeOil = new MaterialLiquid(MapColor.field_151646_E);
    private static boolean effect = true;

    public BlockFluidCrudeOil(Fluid fluid) {
        super(fluid, Material.field_151586_h, "thermalfoundation", "crude_oil");
        this.setQuantaPerBlock(6);
        this.setTickRate(10);
        this.func_149711_c(100.0f);
        this.func_149713_g(7);
        this.setParticleColor(0.2f, 0.2f, 0.2f);
    }

    public static void config() {
        String category = "Fluid.CrudeOil";
        String comment = "If TRUE, Crude Oil will be flammable.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Flammable", category, effect, comment);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return effect ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 25;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return effect;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return effect;
    }

    public boolean preInit() {
        this.setRegistryName("fluid_crude_oil");
        GameRegistry.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        BlockFluidCrudeOil.config();
        return true;
    }
}

