/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.tools.ChatTools;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Logging {
    private static Logging instance = null;
    public static long prevTicks = -1L;
    private Logger logger = LogManager.getLogger();
    public static boolean debugMode = false;
    public static boolean doLogging = false;

    private Logging() {
        instance = this;
    }

    private static Logging getInstance() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    public static void logError(String msg) {
        Logging.getLogger().log(Level.ERROR, msg);
    }

    public static void log(World world, TileEntity te, String message) {
        if (doLogging) {
            long ticks = world.func_82737_E();
            if (ticks != prevTicks) {
                prevTicks = ticks;
                Logging.getInstance().logger.log(Level.INFO, "=== Time " + ticks + " ===");
            }
            String id = te.func_174877_v().func_177958_n() + "," + te.func_174877_v().func_177956_o() + "," + te.func_174877_v().func_177952_p() + ": ";
            Logging.getInstance().logger.log(Level.INFO, id + message);
        }
    }

    public static Logger getLogger() {
        return Logging.getInstance().logger;
    }

    public static void logError(String msg, Throwable e) {
        Logging.getLogger().error(msg, e);
    }

    public static void log(String message) {
        Logging.getInstance().logger.log(Level.INFO, message);
    }

    public static void logDebug(String message) {
        if (debugMode) {
            Logging.getInstance().logger.log(Level.INFO, message);
        }
    }

    public static void message(EntityPlayer player, String message) {
        ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(message));
    }

    public static void warn(EntityPlayer player, String message) {
        ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(message).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
    }
}

