/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.AbstractServerCommand;
import mcjty.lib.network.Argument;
import mcjty.lib.network.CommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.network.PacketIntegerFromServer;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketRequestIntegerFromServer
extends AbstractServerCommand {
    private String clientCommand;
    private String modid;

    public PacketRequestIntegerFromServer() {
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.clientCommand = NetworkTools.readString(buf);
        this.modid = NetworkTools.readString(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkTools.writeString(buf, this.clientCommand);
        NetworkTools.writeString(buf, this.modid);
    }

    public PacketRequestIntegerFromServer(String modid, BlockPos pos, String command, String clientCommand, Argument ... arguments) {
        super(pos, command, arguments);
        this.clientCommand = clientCommand;
        this.modid = modid;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestIntegerFromServer, IMessage> {
        public IMessage onMessage(PacketRequestIntegerFromServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestIntegerFromServer message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.pos);
            if (!(te instanceof CommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            CommandHandler commandHandler = (CommandHandler)te;
            Integer result = commandHandler.executeWithResultInteger(message.command, message.args);
            if (result == null) {
                Logging.log("Command " + message.command + " was not handled!");
                return;
            }
            this.sendReplyToClient(message, result, ctx.getServerHandler().field_147369_b);
        }

        private void sendReplyToClient(PacketRequestIntegerFromServer message, Integer result, EntityPlayerMP player) {
            SimpleNetworkWrapper wrapper = PacketHandler.modNetworking.get(message.modid);
            PacketIntegerFromServer msg = new PacketIntegerFromServer(message.pos, message.clientCommand, result);
            wrapper.sendTo((IMessage)msg, player);
        }
    }
}

