/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental.channels;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlinx.coroutines.experimental.channels.ArrayBroadcastChannel;
import kotlinx.coroutines.experimental.channels.ConflatedBroadcastChannel;
import kotlinx.coroutines.experimental.channels.SendChannel;
import kotlinx.coroutines.experimental.channels.SubscriptionReceiveChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u0005*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0005J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H&\u00a8\u0006\u0006"}, d2={"Lkotlinx/coroutines/experimental/channels/BroadcastChannel;", "E", "Lkotlinx/coroutines/experimental/channels/SendChannel;", "open", "Lkotlinx/coroutines/experimental/channels/SubscriptionReceiveChannel;", "Factory", "kotlinx-coroutines-core"})
public interface BroadcastChannel<E>
extends SendChannel<E> {
    public static final Factory Factory = new Factory(null);

    @NotNull
    public SubscriptionReceiveChannel<E> open();

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lkotlinx/coroutines/experimental/channels/BroadcastChannel$Factory;", "", "()V", "invoke", "Lkotlinx/coroutines/experimental/channels/BroadcastChannel;", "E", "capacity", "", "kotlinx-coroutines-core"})
    public static final class Factory {
        @NotNull
        public final <E> BroadcastChannel<E> invoke(int capacity) {
            BroadcastChannel broadcastChannel;
            switch (capacity) {
                case 0: {
                    throw (Throwable)new IllegalArgumentException("Unsupported 0 capacity for BroadcastChannel");
                }
                case 0x7FFFFFFF: {
                    throw (Throwable)new IllegalArgumentException("Unsupported UNLIMITED capacity for BroadcastChannel");
                }
                case -1: {
                    broadcastChannel = new ConflatedBroadcastChannel();
                    break;
                }
                default: {
                    broadcastChannel = new ArrayBroadcastChannel(capacity);
                }
            }
            return broadcastChannel;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

