/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0082\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0003J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\r\u0010\u0005\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/coroutines/experimental/CommonPool;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "()V", "_pool", "Ljava/util/concurrent/ExecutorService;", "usePrivatePool", "", "Try", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createPlainPool", "createPool", "defaultParallelism", "", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "Ljava/lang/Runnable;", "getOrCreatePoolSync", "shutdownAndRelease", "timeout", "", "shutdownAndRelease$kotlinx_coroutines_core", "toString", "", "usePrivatePool$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public final class CommonPool
extends CoroutineDispatcher {
    private static boolean usePrivatePool;
    private static volatile ExecutorService _pool;
    public static final CommonPool INSTANCE;

    private final <T> T Try(Function0<? extends T> block) {
        T t;
        try {
            t = block.invoke();
        }
        catch (Throwable e) {
            t = null;
        }
        return t;
    }

    private final ExecutorService createPool() {
        ExecutorService $i$a$2$let;
        CommonPool it;
        Class<?> $i$a$1$Try;
        CommonPool this_$iv = this;
        try {
            $i$a$1$Try = Class.forName("java.util.concurrent.ForkJoinPool");
        }
        catch (Throwable e$iv) {
            $i$a$1$Try = null;
        }
        Class<?> clazz = $i$a$1$Try;
        if (clazz == null) {
            return this.createPlainPool();
        }
        Class<?> fjpClass = clazz;
        if (!usePrivatePool) {
            ExecutorService e$iv;
            this_$iv = this;
            try {
                Method method = fjpClass.getMethod("commonPool", new Class[0]);
                Object object = method != null ? method.invoke(null, new Object[0]) : null;
                if (!(object instanceof ExecutorService)) {
                    object = null;
                }
                e$iv = (ExecutorService)object;
            }
            catch (Throwable e$iv2) {
                e$iv = null;
            }
            ExecutorService executorService = e$iv;
            if (executorService != null) {
                it = this_$iv = executorService;
                return it;
            }
        }
        this_$iv = this;
        try {
            Object obj = fjpClass.getConstructor(Integer.TYPE).newInstance(INSTANCE.defaultParallelism());
            if (!(obj instanceof ExecutorService)) {
                obj = null;
            }
            $i$a$2$let = (ExecutorService)obj;
        }
        catch (Throwable e$iv) {
            $i$a$2$let = null;
        }
        ExecutorService executorService = $i$a$2$let;
        if (executorService != null) {
            ExecutorService executorService2 = executorService;
            it = executorService2;
            return it;
        }
        return this.createPlainPool();
    }

    private final ExecutorService createPlainPool() {
        AtomicInteger threadId = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(this.defaultParallelism(), new ThreadFactory(threadId){
            final /* synthetic */ AtomicInteger $threadId;

            @NotNull
            public final Thread newThread(Runnable it) {
                Thread thread2;
                Thread $receiver = thread2 = new Thread(it, "CommonPool-worker-" + this.$threadId.incrementAndGet());
                $receiver.setDaemon(true);
                return thread2;
            }
            {
                this.$threadId = atomicInteger;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(executorService, "Executors.newFixedThread\u2026Daemon = true }\n        }");
        return executorService;
    }

    private final int defaultParallelism() {
        return RangesKt.coerceAtLeast(Runtime.getRuntime().availableProcessors() - 1, 1);
    }

    private final synchronized ExecutorService getOrCreatePoolSync() {
        ExecutorService executorService = _pool;
        if (executorService == null) {
            ExecutorService executorService2;
            ExecutorService it;
            _pool = it = (executorService2 = this.createPool());
            executorService = executorService2;
        }
        return executorService;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        ExecutorService executorService = _pool;
        if (executorService == null) {
            executorService = this.getOrCreatePoolSync();
        }
        executorService.execute(block);
    }

    public final synchronized void usePrivatePool$kotlinx_coroutines_core() {
        this.shutdownAndRelease$kotlinx_coroutines_core(0L);
        usePrivatePool = true;
    }

    public final synchronized void shutdownAndRelease$kotlinx_coroutines_core(long timeout) {
        ExecutorService executorService = _pool;
        if (executorService != null) {
            ExecutorService executorService2;
            ExecutorService $receiver = executorService2 = executorService;
            $receiver.shutdown();
            if (timeout > (long)0) {
                $receiver.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            _pool = null;
        }
        usePrivatePool = false;
    }

    @Override
    @NotNull
    public String toString() {
        return "CommonPool";
    }

    private CommonPool() {
        INSTANCE = this;
    }

    static {
        new CommonPool();
    }
}

