/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.grid.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.IItemGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.block.BlockGrid;
import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.gui.grid.GridFilter;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerGridFilterInGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataConsumer;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileGrid
extends TileNode
implements IGrid {
    public static final TileDataParameter<Integer> VIEW_TYPE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileGrid>(){

        @Override
        public Integer getValue(TileGrid tile) {
            return tile.viewType;
        }
    }, new ITileDataConsumer<Integer, TileGrid>(){

        @Override
        public void setValue(TileGrid tile, Integer value) {
            if (TileGrid.isValidViewType(value)) {
                tile.viewType = value;
                tile.func_70296_d();
            }
        }
    }, parameter -> GuiGrid.markForSorting());
    public static final TileDataParameter<Integer> SORTING_DIRECTION = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileGrid>(){

        @Override
        public Integer getValue(TileGrid tile) {
            return tile.sortingDirection;
        }
    }, new ITileDataConsumer<Integer, TileGrid>(){

        @Override
        public void setValue(TileGrid tile, Integer value) {
            if (TileGrid.isValidSortingDirection(value)) {
                tile.sortingDirection = value;
                tile.func_70296_d();
            }
        }
    }, parameter -> GuiGrid.markForSorting());
    public static final TileDataParameter<Integer> SORTING_TYPE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileGrid>(){

        @Override
        public Integer getValue(TileGrid tile) {
            return tile.sortingType;
        }
    }, new ITileDataConsumer<Integer, TileGrid>(){

        @Override
        public void setValue(TileGrid tile, Integer value) {
            if (TileGrid.isValidSortingType(value)) {
                tile.sortingType = value;
                tile.func_70296_d();
            }
        }
    }, parameter -> GuiGrid.markForSorting());
    public static final TileDataParameter<Integer> SEARCH_BOX_MODE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileGrid>(){

        @Override
        public Integer getValue(TileGrid tile) {
            return tile.searchBoxMode;
        }
    }, new ITileDataConsumer<Integer, TileGrid>(){

        @Override
        public void setValue(TileGrid tile, Integer value) {
            if (TileGrid.isValidSearchBoxMode(value)) {
                tile.searchBoxMode = value;
                tile.func_70296_d();
            }
        }
    }, parameter -> {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiGrid) {
            ((GuiGrid)Minecraft.func_71410_x().field_71462_r).updateSearchFieldFocus((Integer)parameter.getValue());
        }
    });
    public static final TileDataParameter<Boolean> OREDICT_PATTERN = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileGrid>(){

        @Override
        public Boolean getValue(TileGrid tile) {
            return tile.oredictPattern;
        }
    }, new ITileDataConsumer<Boolean, TileGrid>(){

        @Override
        public void setValue(TileGrid tile, Boolean value) {
            tile.oredictPattern = value;
            tile.func_70296_d();
        }
    }, parameter -> {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiGrid) {
            ((GuiGrid)Minecraft.func_71410_x().field_71462_r).updateOredictPattern((Boolean)parameter.getValue());
        }
    });
    public static final String NBT_VIEW_TYPE = "ViewType";
    public static final String NBT_SORTING_DIRECTION = "SortingDirection";
    public static final String NBT_SORTING_TYPE = "SortingType";
    public static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    public static final String NBT_OREDICT_PATTERN = "OredictPattern";
    public static final int SORTING_DIRECTION_ASCENDING = 0;
    public static final int SORTING_DIRECTION_DESCENDING = 1;
    public static final int SORTING_TYPE_QUANTITY = 0;
    public static final int SORTING_TYPE_NAME = 1;
    public static final int SORTING_TYPE_ID = 2;
    public static final int SEARCH_BOX_MODE_NORMAL = 0;
    public static final int SEARCH_BOX_MODE_NORMAL_AUTOSELECTED = 1;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED = 2;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED_AUTOSELECTED = 3;
    public static final int VIEW_TYPE_NORMAL = 0;
    public static final int VIEW_TYPE_NON_CRAFTABLES = 1;
    public static final int VIEW_TYPE_CRAFTABLES = 2;
    private Container craftingContainer = new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            TileGrid.this.onCraftingMatrixChanged();
        }
    };
    private InventoryCrafting matrix = new InventoryCrafting(this.craftingContainer, 3, 3);
    private InventoryCraftResult result = new InventoryCraftResult();
    private ItemHandlerBasic patterns = new ItemHandlerBasic(2, this, new ItemValidatorBasic(RSItems.PATTERN));
    private List<GridFilter> filteredItems = new ArrayList<GridFilter>();
    private ItemHandlerGridFilterInGrid filter = new ItemHandlerGridFilterInGrid(this.filteredItems);
    private EnumGridType type;
    private int viewType = 0;
    private int sortingDirection = 1;
    private int sortingType = 0;
    private int searchBoxMode = 0;
    private boolean oredictPattern = false;

    public TileGrid() {
        this.dataManager.addWatchedParameter(VIEW_TYPE);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(OREDICT_PATTERN);
    }

    @Override
    public int getEnergyUsage() {
        switch (this.getType()) {
            case NORMAL: {
                return RS.INSTANCE.config.gridUsage;
            }
            case CRAFTING: {
                return RS.INSTANCE.config.craftingGridUsage;
            }
            case PATTERN: {
                return RS.INSTANCE.config.patternGridUsage;
            }
            case FLUID: {
                return RS.INSTANCE.config.fluidGridUsage;
            }
        }
        return 0;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public EnumGridType getType() {
        if (this.type == null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == RSBlocks.GRID) {
            this.type = (EnumGridType)((Object)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGrid.TYPE));
        }
        return this.type == null ? EnumGridType.NORMAL : this.type;
    }

    @Override
    public BlockPos getNetworkPosition() {
        return this.network != null ? this.network.getPosition() : null;
    }

    public void onOpened(EntityPlayer player) {
        if (this.isConnected()) {
            if (this.getType() == EnumGridType.FLUID) {
                this.network.sendFluidStorageToClient((EntityPlayerMP)player);
            } else {
                this.network.sendItemStorageToClient((EntityPlayerMP)player);
            }
        }
    }

    @Override
    public IItemGridHandler getItemHandler() {
        return this.connected ? this.network.getItemGridHandler() : null;
    }

    @Override
    public IFluidGridHandler getFluidHandler() {
        return this.connected ? this.network.getFluidGridHandler() : null;
    }

    @Override
    public String getGuiTitle() {
        return this.getType() == EnumGridType.FLUID ? "gui.refinedstorage:fluid_grid" : "gui.refinedstorage:grid";
    }

    public InventoryCrafting getMatrix() {
        return this.matrix;
    }

    public InventoryCraftResult getResult() {
        return this.result;
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    @Override
    public ItemHandlerBasic getFilter() {
        return this.filter;
    }

    @Override
    public List<GridFilter> getFilters() {
        return this.filteredItems;
    }

    public void onCraftingMatrixChanged() {
        this.func_70296_d();
        this.result.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.matrix, this.func_145831_w()));
    }

    public void onCrafted(EntityPlayer player) {
        ItemStack[] remainder = CraftingManager.func_77594_a().func_180303_b(this.matrix, this.func_145831_w());
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            ItemStack slot = this.matrix.func_70301_a(i);
            if (i < remainder.length && remainder[i] != null) {
                if (slot != null && slot.field_77994_a > 1) {
                    ItemStack remainderStack;
                    if (!player.field_71071_by.func_70441_a(remainder[i].func_77946_l()) && (remainderStack = this.network.insertItem(remainder[i].func_77946_l(), remainder[i].field_77994_a, false)) != null) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainderStack);
                    }
                    this.matrix.func_70298_a(i, 1);
                    continue;
                }
                this.matrix.func_70299_a(i, remainder[i].func_77946_l());
                continue;
            }
            if (slot == null) continue;
            if (slot.field_77994_a == 1 && this.isConnected()) {
                this.matrix.func_70299_a(i, this.network.extractItem(slot, 1, false));
                continue;
            }
            this.matrix.func_70298_a(i, 1);
        }
        this.onCraftingMatrixChanged();
    }

    public void onCraftedShift(ContainerGrid container, EntityPlayer player) {
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int craftedItems = 0;
        ItemStack crafted = this.result.func_70301_a(0);
        do {
            this.onCrafted(player);
            craftedItemsList.add(crafted.func_77946_l());
        } while (API.instance().getComparer().isEqual(crafted, this.result.func_70301_a(0)) && (craftedItems += crafted.field_77994_a) + crafted.field_77994_a <= crafted.func_77976_d());
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack remainder;
            if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l()) || (remainder = this.network.insertItem(craftedItem, craftedItem.field_77994_a, false)) == null) continue;
            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainder);
        }
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)craftedItems), (IInventory)this.matrix);
        container.sendCraftingSlots();
        container.func_75142_b();
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            this.patterns.extractItem(0, 1, false);
            ItemStack pattern = new ItemStack((Item)RSItems.PATTERN);
            ItemPattern.setOredict(pattern, this.oredictPattern);
            for (int i = 0; i < 9; ++i) {
                ItemStack ingredient = this.matrix.func_70301_a(i);
                if (ingredient == null) continue;
                ItemPattern.setSlot(pattern, i, ingredient);
            }
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    public boolean canCreatePattern() {
        return this.result.func_70301_a(0) != null && this.patterns.getStackInSlot(1) == null && this.patterns.getStackInSlot(0) != null;
    }

    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
        int i;
        for (i = 0; i < this.matrix.func_70302_i_(); ++i) {
            ItemStack slot = this.matrix.func_70301_a(i);
            if (slot == null) continue;
            if (this.getType() == EnumGridType.CRAFTING) {
                if (this.isConnected()) {
                    if (this.network.insertItem(slot, slot.field_77994_a, true) != null) {
                        return;
                    }
                    this.network.insertItem(slot, slot.field_77994_a, false);
                } else if (!player.field_71071_by.func_70441_a(slot.func_77946_l())) {
                    return;
                }
            }
            this.matrix.func_70299_a(i, null);
        }
        block1: for (i = 0; i < this.matrix.func_70302_i_(); ++i) {
            if (recipe[i] == null) continue;
            ItemStack[] possibilities = recipe[i];
            if (this.getType() == EnumGridType.CRAFTING) {
                boolean found = false;
                if (this.isConnected()) {
                    ItemStack[] itemStackArray = possibilities;
                    int n = itemStackArray.length;
                    for (int j = 0; j < n; ++j) {
                        ItemStack possibility;
                        ItemStack took = this.network.extractItem(possibility, 1, 0x12 | ((possibility = itemStackArray[j]).func_77973_b().func_77645_m() ? 0 : 1), false);
                        if (took == null) continue;
                        this.matrix.func_70299_a(i, took);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (ItemStack possibility : possibilities) {
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        if (!API.instance().getComparer().isEqual(possibility, player.field_71071_by.func_70301_a(j), 0x12 | (possibility.func_77973_b().func_77645_m() ? 0 : 1))) continue;
                        this.matrix.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.field_71071_by.func_70301_a(j), (int)1));
                        player.field_71071_by.func_70298_a(j, 1);
                        found = true;
                        break;
                    }
                    if (found) continue block1;
                }
                continue;
            }
            if (this.getType() != EnumGridType.PATTERN) continue;
            this.matrix.func_70299_a(i, possibilities[0]);
        }
    }

    @Override
    public int getViewType() {
        return this.func_145831_w().field_72995_K ? VIEW_TYPE.getValue() : this.viewType;
    }

    @Override
    public int getSortingDirection() {
        return this.func_145831_w().field_72995_K ? SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSortingType() {
        return this.func_145831_w().field_72995_K ? SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSearchBoxMode() {
        return this.func_145831_w().field_72995_K ? SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public void onViewTypeChanged(int type) {
        TileDataManager.setParameter(VIEW_TYPE, type);
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeConfig() {
        return REDSTONE_MODE;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItemsLegacy((IInventory)this.matrix, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.patterns, 1, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.filter, 2, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItemsLegacy((IInventory)this.matrix, 0, tag);
        RSUtils.writeItems((IItemHandler)this.patterns, 1, tag);
        RSUtils.writeItems((IItemHandler)this.filter, 2, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_VIEW_TYPE, this.viewType);
        tag.func_74768_a(NBT_SORTING_DIRECTION, this.sortingDirection);
        tag.func_74768_a(NBT_SORTING_TYPE, this.sortingType);
        tag.func_74768_a(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        tag.func_74757_a(NBT_OREDICT_PATTERN, this.oredictPattern);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_VIEW_TYPE)) {
            this.viewType = tag.func_74762_e(NBT_VIEW_TYPE);
        }
        if (tag.func_74764_b(NBT_SORTING_DIRECTION)) {
            this.sortingDirection = tag.func_74762_e(NBT_SORTING_DIRECTION);
        }
        if (tag.func_74764_b(NBT_SORTING_TYPE)) {
            this.sortingType = tag.func_74762_e(NBT_SORTING_TYPE);
        }
        if (tag.func_74764_b(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.func_74762_e(NBT_SEARCH_BOX_MODE);
        }
        if (tag.func_74764_b(NBT_OREDICT_PATTERN)) {
            this.oredictPattern = tag.func_74767_n(NBT_OREDICT_PATTERN);
        }
    }

    @Override
    public IItemHandler getDrops() {
        switch (this.getType()) {
            case CRAFTING: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, new InvWrapper((IInventory)this.matrix)});
            }
            case PATTERN: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, this.patterns});
            }
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter});
    }

    public static boolean isValidViewType(int type) {
        return type == 0 || type == 2 || type == 1;
    }

    public static boolean isValidSearchBoxMode(int mode) {
        return mode == 0 || mode == 1 || mode == 2 || mode == 3;
    }

    public static boolean isSearchBoxModeWithAutoselection(int mode) {
        return mode == 1 || mode == 3;
    }

    public static boolean isValidSortingType(int type) {
        return type == 0 || type == 1 || type == 2;
    }

    public static boolean isValidSortingDirection(int direction) {
        return direction == 0 || direction == 1;
    }
}

