/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerInterface;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileInterface
extends TileNode
implements IComparable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private ItemHandlerBasic importItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerBasic exportSpecimenItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerBasic exportItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerInterface items = new ItemHandlerInterface((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 4, 3);
    private int compare = 3;
    private int currentSlot = 0;

    public TileInterface() {
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.interfaceUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        ItemStack slot;
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)) == null) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.field_77994_a, this.upgrades.getInteractStackSize());
            ItemStack remainder = this.network.insertItem(slot, size, false);
            if (remainder == null) {
                this.importItems.extractItemInternal(this.currentSlot, size, false);
            } else if (size - remainder.field_77994_a > 0) {
                this.importItems.extractItemInternal(this.currentSlot, size - remainder.field_77994_a, false);
                ++this.currentSlot;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.exportSpecimenItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted == null) {
                if (got == null) continue;
                this.exportItems.setStackInSlot(i, this.network.insertItem(got, got.field_77994_a, false));
                continue;
            }
            int n = delta = got == null ? wanted.field_77994_a : wanted.field_77994_a - got.field_77994_a;
            if (delta > 0) {
                ItemStack result = this.network.extractItem(wanted, delta, this.compare, false);
                if (result != null) {
                    if (this.exportItems.getStackInSlot(i) == null) {
                        this.exportItems.setStackInSlot(i, result);
                        continue;
                    }
                    this.exportItems.getStackInSlot((int)i).field_77994_a += result.field_77994_a;
                    continue;
                }
                if (!this.upgrades.hasUpgrade(3)) continue;
                this.network.scheduleCraftingTask(wanted, delta, this.compare);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItem(got, Math.abs(delta), false);
            if (remainder == null) {
                this.exportItems.extractItem(i, Math.abs(delta), false);
                continue;
            }
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.field_77994_a, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.importItems, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.exportItems, 2, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItems((IItemHandler)this.importItems, 0, tag);
        RSUtils.writeItems((IItemHandler)this.exportItems, 2, tag);
        RSUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        RSUtils.writeItems((IItemHandler)this.exportSpecimenItems, 1, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.exportSpecimenItems, 1, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportSpecimenItems() {
        return this.exportSpecimenItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.items;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

