/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.integration.cyclopscore.IntegrationCyclopsCore;
import com.raoulvdberge.refinedstorage.integration.cyclopscore.SlotlessItemHandlerHelper;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileMultipartNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileExporter
extends TileMultipartNode
implements IComparable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 3, 4);
    private int compare = 3;
    private int type = 0;

    public TileExporter() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExporter.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        block5: {
            IFluidHandler handler;
            block6: {
                if (this.ticks % this.upgrades.getSpeed() != 0) break block5;
                if (this.type != 0) break block6;
                IItemHandler handler2 = RSUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
                if (handler2 == null && (!IntegrationCyclopsCore.isLoaded() || !SlotlessItemHandlerHelper.isSlotless(this.getFacingTile(), this.getDirection().func_176734_d()))) break block5;
                for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                    ItemStack slot = this.itemFilters.getStackInSlot(i);
                    if (slot == null) continue;
                    ItemStack took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), this.upgrades.getInteractStackSize()), this.compare, true);
                    if (took == null) {
                        if (!this.upgrades.hasUpgrade(3)) continue;
                        this.network.scheduleCraftingTask(slot, 1, this.compare);
                        continue;
                    }
                    if (IntegrationCyclopsCore.isLoaded() && SlotlessItemHandlerHelper.isSlotless(this.getFacingTile(), this.getDirection().func_176734_d()) && SlotlessItemHandlerHelper.insertItem(this.getFacingTile(), this.getDirection().func_176734_d(), took, true) == null) {
                        took = this.network.extractItem(slot, this.upgrades.getInteractStackSize(), this.compare, false);
                        SlotlessItemHandlerHelper.insertItem(this.getFacingTile(), this.getDirection().func_176734_d(), took, false);
                        continue;
                    }
                    if (handler2 == null || ItemHandlerHelper.insertItem((IItemHandler)handler2, (ItemStack)took, (boolean)true) != null) continue;
                    took = this.network.extractItem(slot, this.upgrades.getInteractStackSize(), this.compare, false);
                    ItemHandlerHelper.insertItem((IItemHandler)handler2, (ItemStack)took, (boolean)false);
                }
                break block5;
            }
            if (this.type == 1 && (handler = RSUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null) {
                for (FluidStack stack : this.fluidFilters.getFluids()) {
                    int filled;
                    int toExtract;
                    FluidStack took;
                    FluidStack stackInStorage;
                    if (stack == null || (stackInStorage = this.network.getFluidStorageCache().getList().get(stack, this.compare)) == null || (took = this.network.extractFluid(stack, toExtract = Math.min(1000 * this.upgrades.getInteractStackSize(), stackInStorage.amount), this.compare, true)) == null || (filled = handler.fill(took, false)) <= 0) continue;
                    took = this.network.extractFluid(stack, filled, this.compare, false);
                    handler.fill(took, true);
                    break;
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        RSUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        RSUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        RSUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.func_145831_w().field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

