/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileMultipartNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataConsumer;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDestructor
extends TileMultipartNode
implements IComparable,
IFilterable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final TileDataParameter<Boolean> PICKUP = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileDestructor>(){

        @Override
        public Boolean getValue(TileDestructor tile) {
            return tile.pickupItem;
        }
    }, new ITileDataConsumer<Boolean, TileDestructor>(){

        @Override
        public void setValue(TileDestructor tile, Boolean value) {
            tile.pickupItem = value;
            tile.func_70296_d();
        }
    });
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 6, 7);
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private boolean pickupItem = false;

    public TileDestructor() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(PICKUP);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileDestructor.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.destructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        if (this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            BlockPos front = this.field_174879_c.func_177972_a(this.getDirection());
            if (this.pickupItem && this.type == 0) {
                ArrayList droppedItems = new ArrayList();
                Chunk chunk = this.func_145831_w().func_175726_f(front);
                chunk.func_177414_a(null, new AxisAlignedBB(front), droppedItems, null);
                for (Entity entity : droppedItems) {
                    ItemStack droppedItem;
                    if (!(entity instanceof EntityItem) || !IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, droppedItem = ((EntityItem)entity).func_92059_d()) || this.network.insertItem(droppedItem, droppedItem.field_77994_a, true) != null) continue;
                    this.network.insertItem(droppedItem.func_77946_l(), droppedItem.field_77994_a, false);
                    this.func_145831_w().func_72900_e(entity);
                    break;
                }
            } else if (this.type == 0) {
                IBlockState frontBlockState = this.func_145831_w().func_180495_p(front);
                Block frontBlock = frontBlockState.func_177230_c();
                ItemStack frontStack = frontBlock.getPickBlock(frontBlockState, null, this.func_145831_w(), front, null);
                if (frontStack != null && IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, frontStack) && (double)frontBlockState.func_185887_b(this.func_145831_w(), front) != -1.0) {
                    List<ItemStack> drops = this.upgrades.hasUpgrade(6) && frontBlock.canSilkHarvest(this.func_145831_w(), front, frontBlockState, null) ? Collections.singletonList(frontStack) : frontBlock.getDrops((IBlockAccess)this.func_145831_w(), front, frontBlockState, this.upgrades.getFortuneLevel());
                    for (ItemStack drop : drops) {
                        if (this.network.insertItem(drop, drop.field_77994_a, true) == null) continue;
                        return;
                    }
                    BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.func_145831_w(), front, frontBlockState, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())));
                    if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
                        this.func_145831_w().func_180498_a(null, 2001, front, Block.func_176210_f((IBlockState)frontBlockState));
                        this.func_145831_w().func_175698_g(front);
                        for (ItemStack drop : drops) {
                            if (this.network == null) {
                                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                                continue;
                            }
                            this.network.insertItem(drop, drop.field_77994_a, false);
                        }
                    }
                }
            } else if (this.type == 1) {
                FluidStack stack;
                Block frontBlock = this.func_145831_w().func_180495_p(front).func_177230_c();
                BlockLiquidWrapper handler = null;
                if (frontBlock instanceof BlockLiquid) {
                    handler = new BlockLiquidWrapper((BlockLiquid)frontBlock, this.func_145831_w(), front);
                } else if (frontBlock instanceof IFluidBlock) {
                    handler = new FluidBlockWrapper((IFluidBlock)frontBlock, this.func_145831_w(), front);
                }
                if (handler != null && (stack = handler.drain(1000, false)) != null && IFilterable.canTakeFluids(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, true) == null) {
                    FluidStack drained = handler.drain(1000, true);
                    this.network.insertFluid(drained, drained.amount, false);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_PICKUP, this.pickupItem);
        RSUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        RSUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_PICKUP)) {
            this.pickupItem = tag.func_74767_n(NBT_PICKUP);
        }
        RSUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.func_145831_w().field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

