/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemUpgrade;
import net.minecraft.tileentity.TileEntity;

public class ItemHandlerUpgrade
extends ItemHandlerBasic {
    public ItemHandlerUpgrade(int size, TileEntity tile, int ... supportedUpgrades) {
        super(size, tile, new IItemValidator[supportedUpgrades.length]);
        for (int i = 0; i < supportedUpgrades.length; ++i) {
            this.validators[i] = new ItemValidatorBasic(RSItems.UPGRADE, supportedUpgrades[i]);
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot(i).func_77952_i() != 2) continue;
            speed -= speedIncrease;
        }
        return speed;
    }

    public boolean hasUpgrade(int type) {
        return this.getUpgradeCount(type) > 0;
    }

    public int getUpgradeCount(int type) {
        int upgrades = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot(i).func_77952_i() != type) continue;
            ++upgrades;
        }
        return upgrades;
    }

    public int getEnergyUsage() {
        int usage = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null) continue;
            usage += ItemUpgrade.getEnergyUsage(this.getStackInSlot(i));
        }
        return usage;
    }

    public int getFortuneLevel() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot(i).func_77952_i() != 7) continue;
            return ItemUpgrade.getFortuneLevel(this.getStackInSlot(i));
        }
        return 0;
    }

    public int getInteractStackSize() {
        return this.hasUpgrade(4) ? 64 : 1;
    }
}

