/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.ic2;

import com.raoulvdberge.refinedstorage.integration.ic2.IControllerEnergyIC2;
import com.raoulvdberge.refinedstorage.integration.ic2.IntegrationIC2;
import com.raoulvdberge.refinedstorage.tile.TileController;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.prefab.BasicSink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ControllerEnergyIC2
implements IControllerEnergyIC2 {
    private BasicSink sink;

    public ControllerEnergyIC2(final TileController controller) {
        this.sink = new BasicSink(controller, (int)IntegrationIC2.toEU(controller.getEnergy().getMaxEnergyStored()), 3){

            public double getDemandedEnergy() {
                return Math.max(0.0, IntegrationIC2.toEU(controller.getEnergy().getMaxEnergyStored()) - IntegrationIC2.toEU(controller.getEnergy().getEnergyStored()));
            }

            public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
                controller.getEnergy().setEnergyStored(controller.getEnergy().getEnergyStored() + IntegrationIC2.toRS(amount));
                return 0.0;
            }

            public void onLoaded() {
                if (!this.addedToEnet && !this.parent.func_145831_w().field_72995_K && Info.isIc2Available()) {
                    this.field_145850_b = this.parent.func_145831_w();
                    this.field_174879_c = this.parent.func_174877_v();
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                    this.addedToEnet = true;
                }
            }
        };
    }

    @Override
    public void invalidate() {
        this.sink.func_145843_s();
    }

    @Override
    public void update() {
        this.sink.func_73660_a();
    }

    @Override
    public void onChunkUnload() {
        this.sink.onChunkUnload();
    }
}

