/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.forgeenergy;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ReaderWriterHandlerForgeEnergy
implements IReaderWriterHandler {
    public static final String ID = "forgeenergy";
    private static final String NBT_ENERGY_STORED = "EnergyStored";
    private EnergyStorage storage = new EnergyStorage(4000);
    private EnergyStorageReaderWriter storageReader = new EnergyStorageReaderWriter((IEnergyStorage)this.storage, false, true);
    private EnergyStorageReaderWriter storageWriter = new EnergyStorageReaderWriter((IEnergyStorage)this.storage, true, false);

    public ReaderWriterHandlerForgeEnergy(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b(NBT_ENERGY_STORED)) {
            this.storage.receiveEnergy(tag.func_74762_e(NBT_ENERGY_STORED), false);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapability(IReaderWriter readerWriter, Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY && (readerWriter instanceof IReader || readerWriter instanceof IWriter);
    }

    @Override
    public <T> T getCapability(IReaderWriter readerWriter, Capability<T> capability) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (readerWriter instanceof IReader) {
                return (T)this.storageReader;
            }
            if (readerWriter instanceof IWriter) {
                return (T)this.storageWriter;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a(NBT_ENERGY_STORED, this.storage.getEnergyStored());
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    private class EnergyStorageReaderWriter
    implements IEnergyStorage {
        private IEnergyStorage parent;
        private boolean canExtract;
        private boolean canReceive;

        public EnergyStorageReaderWriter(IEnergyStorage parent, boolean canExtract, boolean canReceive) {
            this.canExtract = canExtract;
            this.canReceive = canReceive;
            this.parent = parent;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.canReceive ? this.parent.receiveEnergy(maxReceive, simulate) : 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.canExtract ? this.parent.extractEnergy(maxExtract, simulate) : 0;
        }

        public int getEnergyStored() {
            return this.parent.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.parent.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.canExtract;
        }

        public boolean canReceive() {
            return this.canReceive;
        }
    }
}

