/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class GridStackItem
implements IGridStack {
    private int hash;
    private ItemStack stack;
    private boolean craftable;
    private String[] oreIds;

    public GridStackItem(ByteBuf buf) {
        this.stack = RSUtils.readItemStack(buf);
        this.hash = buf.readInt();
        this.craftable = buf.readBoolean();
        this.oreIds = null;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.func_82833_r();
    }

    @Override
    public String getModId() {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.stack.func_77973_b())).func_110624_b();
    }

    @Override
    public String[] getOreIds() {
        if (this.oreIds == null) {
            this.oreIds = Arrays.stream(OreDictionary.getOreIDs((ItemStack)this.stack)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList()).toArray(new String[0]);
        }
        return this.oreIds;
    }

    @Override
    public String getTooltip() {
        List lines = this.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        for (int i = 0; i < lines.size(); ++i) {
            if (i == 0) {
                lines.set(i, this.stack.func_77953_t().field_77937_e + (String)lines.get(i));
                continue;
            }
            lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
        }
        return Strings.join((List)lines, (String)"\n");
    }

    @Override
    public int getQuantity() {
        return this.stack.field_77994_a;
    }

    private String getQuantityForDisplay(boolean advanced) {
        int qty = this.stack.field_77994_a;
        if (advanced && qty > 1) {
            return String.valueOf(qty);
        }
        if (qty == 1) {
            return null;
        }
        if (qty == 0) {
            return I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        }
        return RSUtils.formatQuantity(qty);
    }

    @Override
    public void draw(GuiBase gui, int x, int y, boolean isOverWithShift) {
        gui.drawItem(x, y, this.stack, true, this.getQuantityForDisplay(isOverWithShift));
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    public boolean equals(Object obj) {
        return obj instanceof IGridStack && ((GridStackItem)obj).getHash() == this.hash;
    }
}

