/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.grid.GuiCraftingStart;
import com.raoulvdberge.refinedstorage.gui.grid.IGridDisplay;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorting;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingID;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingName;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSortingQuantity;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonGridSearchBoxMode;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonGridSortingDirection;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonGridSortingType;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonGridViewType;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.integration.jei.IntegrationJEI;
import com.raoulvdberge.refinedstorage.integration.jei.RSJEIPlugin;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingClear;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidPull;
import com.raoulvdberge.refinedstorage.network.MessageGridItemInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridItemPull;
import com.raoulvdberge.refinedstorage.network.MessageGridPatternCreate;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiGrid
extends GuiBase
implements IGridDisplay {
    private static final GridSorting SORTING_QUANTITY = new GridSortingQuantity();
    private static final GridSorting SORTING_NAME = new GridSortingName();
    private static final GridSorting SORTING_ID = new GridSortingID();
    public static final ListMultimap<Item, GridStackItem> ITEMS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    public static final ListMultimap<Fluid, GridStackFluid> FLUIDS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    public static List<IGridStack> STACKS = new ArrayList<IGridStack>();
    private static boolean markedForSorting;
    private boolean wasConnected;
    private GuiTextField searchField;
    private GuiCheckBox oredictPattern;
    private IGrid grid;
    private int slotNumber;
    private Deque<Integer> konami = new ArrayDeque<Integer>(Arrays.asList(200, 200, 208, 208, 203, 205, 203, 205, 48, 30));
    private int[] konamiOffsetsX;
    private int[] konamiOffsetsY;

    public static void markForSorting() {
        markedForSorting = true;
    }

    public GuiGrid(ContainerGrid container, IGrid grid) {
        super(container, grid.getType() == EnumGridType.FLUID ? 193 : 227, 0);
        this.grid = grid;
        this.wasConnected = grid.isConnected();
        this.scrollbar = new Scrollbar(174, 20, 12, grid.getType() == EnumGridType.CRAFTING || grid.getType() == EnumGridType.PATTERN || grid.getType() == EnumGridType.FLUID ? 70 : 88);
    }

    @Override
    protected void calcHeight() {
        this.screenHeight = this.field_147000_g = this.getHeader() + this.getFooter() + this.getVisibleRows() * 18;
    }

    @Override
    public void init(int x, int y) {
        ((ContainerGrid)this.field_147002_h).initSlots();
        this.scrollbar = new Scrollbar(174, this.getHeader(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid.getRedstoneModeConfig() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.grid.getRedstoneModeConfig()));
        }
        this.konamiOffsetsX = new int[9 * this.getVisibleRows()];
        this.konamiOffsetsY = new int[9 * this.getVisibleRows()];
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new GuiTextField(0, this.field_146289_q, sx, sy, 82, this.field_146289_q.field_78288_b);
            this.searchField.func_146185_a(false);
            this.searchField.func_146189_e(true);
            this.searchField.func_146193_g(0xFFFFFF);
            this.updateSearchFieldFocus(this.grid.getSearchBoxMode());
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
        if (this.grid.getType() == EnumGridType.PATTERN) {
            this.oredictPattern = this.addCheckBox(x + 64, y + this.getHeader() + this.getVisibleRows() * 18 + 46, GuiGrid.t("misc.refinedstorage:oredict", new Object[0]), TileGrid.OREDICT_PATTERN.getValue());
        }
        if (this.grid.getType() != EnumGridType.FLUID) {
            this.addSideButton(new SideButtonGridViewType(this, this.grid));
        }
        this.addSideButton(new SideButtonGridSortingDirection(this, this.grid));
        this.addSideButton(new SideButtonGridSortingType(this, this.grid));
        this.addSideButton(new SideButtonGridSearchBoxMode(this));
        this.sortItems();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    private void sortItems() {
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (this.grid.isConnected()) {
            stacks.addAll(this.grid.getType() == EnumGridType.FLUID ? FLUIDS.values() : ITEMS.values());
            List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(this.grid, this.searchField.func_146179_b(), this.grid.getFilters());
            Iterator t = stacks.iterator();
            block0: while (t.hasNext()) {
                IGridStack stack = (IGridStack)t.next();
                for (Predicate<IGridStack> filter : filters) {
                    if (filter.test(stack)) continue;
                    t.remove();
                    continue block0;
                }
            }
            SORTING_NAME.setSortingDirection(this.grid.getSortingDirection());
            SORTING_QUANTITY.setSortingDirection(this.grid.getSortingDirection());
            SORTING_ID.setSortingDirection(this.grid.getSortingDirection());
            Collections.sort(stacks, SORTING_NAME);
            if (this.grid.getSortingType() == 0) {
                Collections.sort(stacks, SORTING_QUANTITY);
            } else if (this.grid.getSortingType() == 2) {
                Collections.sort(stacks, SORTING_ID);
            }
        }
        STACKS = stacks;
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    @Override
    public void update(int x, int y) {
        if (this.konami.isEmpty()) {
            for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
                int n = i;
                this.konamiOffsetsX[n] = this.konamiOffsetsX[n] + (ThreadLocalRandom.current().nextBoolean() ? 1 : -1) * ThreadLocalRandom.current().nextInt(5);
                int n2 = i;
                this.konamiOffsetsY[n2] = this.konamiOffsetsY[n2] + (ThreadLocalRandom.current().nextBoolean() ? 1 : -1) * ThreadLocalRandom.current().nextInt(5);
            }
        }
        if (this.wasConnected != this.grid.isConnected()) {
            this.wasConnected = this.grid.isConnected();
            GuiGrid.markForSorting();
        }
        if (markedForSorting) {
            markedForSorting = false;
            this.sortItems();
        }
    }

    @Override
    public int getHeader() {
        return 19;
    }

    @Override
    public int getFooter() {
        return this.grid.getType() == EnumGridType.CRAFTING || this.grid.getType() == EnumGridType.PATTERN ? 156 : 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getHeader() + this.getVisibleRows() * 18;
        if (this.grid.getType() == EnumGridType.NORMAL || this.grid.getType() == EnumGridType.FLUID) {
            yp += 16;
        } else if (this.grid.getType() == EnumGridType.CRAFTING || this.grid.getType() == EnumGridType.PATTERN) {
            yp += 73;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)STACKS.size() / 9.0f));
    }

    @Override
    public int getVisibleRows() {
        int screenSpaceAvailable = this.field_146295_m - this.getHeader() - this.getFooter();
        return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRows));
    }

    private boolean isOverSlotWithItem() {
        return this.grid.isConnected() && this.isOverSlot() && this.slotNumber < STACKS.size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(int mouseX, int mouseY) {
        return this.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        int y = this.getHeader() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getType()) {
            case CRAFTING: {
                return this.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                return this.inBounds(64, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.grid.getType() == EnumGridType.PATTERN && this.inBounds(152, this.getHeader() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((TileGrid)this.grid).canCreatePattern();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        if (this.grid.getType() == EnumGridType.CRAFTING) {
            this.bindTexture("gui/crafting_grid.png");
        } else if (this.grid.getType() == EnumGridType.PATTERN) {
            this.bindTexture("gui/pattern_grid.png");
        } else {
            this.bindTexture("gui/grid.png");
        }
        int yy = y;
        this.drawTexture(x, yy, 0, 0, this.screenWidth - (this.grid.getType() != EnumGridType.FLUID ? 34 : 0), this.getHeader());
        if (this.grid.getType() != EnumGridType.FLUID) {
            this.drawTexture(x + this.screenWidth - 34 + 4, y, 197, 0, 30, 82);
        }
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            this.drawTexture(x, yy += 18, 0, this.getHeader() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth - (this.grid.getType() != EnumGridType.FLUID ? 34 : 0), 18);
        }
        this.drawTexture(x, yy += 18, 0, this.getHeader() + 54, this.screenWidth - (this.grid.getType() != EnumGridType.FLUID ? 34 : 0), this.getFooter());
        if (this.grid.getType() == EnumGridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((TileGrid)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.drawTexture(x + 152, y + this.getHeader() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
        }
        this.searchField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiGrid.t(this.grid.getGuiTitle(), new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiGrid.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 19;
        this.slotNumber = -1;
        int slot = this.scrollbar.getOffset() * 9;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            int yy;
            int xx = x + (this.konami.isEmpty() ? this.konamiOffsetsX[i] : 0);
            if (this.inBounds(xx, yy = y + (this.konami.isEmpty() ? this.konamiOffsetsY[i] : 0), 16, 16, mouseX, mouseY) || !this.grid.isConnected()) {
                this.slotNumber = slot;
            }
            if (slot < STACKS.size()) {
                STACKS.get(slot).draw(this, xx, yy, GuiScreen.func_146272_n() && this.slotNumber == slot);
            }
            if (this.inBounds(xx, yy, 16, 16, mouseX, mouseY) || !this.grid.isConnected()) {
                int color = this.grid.isConnected() ? -2130706433 : -10790053;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.field_73735_i = 190.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(xx, yy, xx + 16, yy + 16, color, color);
                this.field_73735_i = 0.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverSlotWithItem()) {
            this.drawTooltip(mouseX, mouseY, STACKS.get(this.slotNumber).getTooltip());
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("misc.refinedstorage:clear", new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("gui.refinedstorage:grid.pattern_create", new Object[0]));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.oredictPattern) {
            TileDataManager.setParameter(TileGrid.OREDICT_PATTERN, this.oredictPattern.isChecked());
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        boolean clickedCreatePattern;
        super.func_73864_a(mouseX, mouseY, clickedButton);
        this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        if (clickedButton == 1 && this.inBounds(79, 5, 90, 12, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            this.searchField.func_146180_a("");
            this.searchField.func_146195_b(true);
            this.sortItems();
            this.updateJEI();
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (clickedCreatePattern) {
            BlockPos gridPos = ((TileGrid)this.grid).func_174877_v();
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternCreate(gridPos.func_177958_n(), gridPos.func_177956_o(), gridPos.func_177952_p()));
        } else if (this.grid.isConnected()) {
            if (clickedClear) {
                RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingClear((TileGrid)this.grid));
            }
            ItemStack held = ((ContainerGrid)this.field_147002_h).getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && held != null && (clickedButton == 0 || clickedButton == 1)) {
                RS.INSTANCE.network.sendToServer((IMessage)(this.grid.getType() == EnumGridType.FLUID ? new MessageGridFluidInsertHeld() : new MessageGridItemInsertHeld(clickedButton == 1)));
            }
            if (this.isOverSlotWithItem()) {
                if (this.grid.getType() != EnumGridType.FLUID && (held == null || held != null && clickedButton == 2)) {
                    GridStackItem stack = (GridStackItem)STACKS.get(this.slotNumber);
                    if (stack.isCraftable() && (stack.getQuantity() == 0 || GuiScreen.func_146272_n() && GuiScreen.func_146271_m())) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiCraftingStart(this, ((ContainerGrid)this.field_147002_h).getPlayer(), stack));
                    } else {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GuiScreen.func_146272_n()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemPull(stack.getHash(), flags));
                    }
                } else if (this.grid.getType() == EnumGridType.FLUID && held == null) {
                    RS.INSTANCE.network.sendToServer((IMessage)new MessageGridFluidPull(STACKS.get(this.slotNumber).getHash(), GuiScreen.func_146272_n()));
                }
            }
        }
        if (clickedClear || clickedCreatePattern) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (!this.konami.isEmpty() && this.konami.peek() == keyCode) {
            this.konami.pop();
        }
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(character, keyCode)) {
                this.updateJEI();
                this.sortItems();
            } else if (keyCode == RSKeyBindings.BINDING_FOCUS_SEARCH_BAR.func_151463_i() && (this.grid.getSearchBoxMode() == 0 || this.grid.getSearchBoxMode() == 2)) {
                this.searchField.func_146195_b(!this.searchField.func_146206_l());
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    private void updateJEI() {
        if (IntegrationJEI.isLoaded() && (this.grid.getSearchBoxMode() == 2 || this.grid.getSearchBoxMode() == 3)) {
            RSJEIPlugin.INSTANCE.getRuntime().getItemListOverlay().setFilterText(this.searchField.func_146179_b());
        }
    }

    public void updateSearchFieldFocus(int mode) {
        if (this.searchField != null) {
            this.searchField.func_146205_d(!TileGrid.isSearchBoxModeWithAutoselection(mode));
            this.searchField.func_146195_b(TileGrid.isSearchBoxModeWithAutoselection(mode));
        }
    }

    public GuiTextField getSearchField() {
        return this.searchField;
    }

    public void updateOredictPattern(boolean checked) {
        if (this.oredictPattern != null) {
            this.oredictPattern.setIsChecked(checked);
        }
    }
}

