/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingSettings;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreview;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingStart
extends GuiBase {
    private static final int DEFAULT_AMOUNT = 1;
    protected GuiTextField amountField;
    private GuiBase parent;
    private GridStackItem stack;
    private GuiButton startButton;
    private GuiButton cancelButton;
    private GuiButton[] incrementButtons = new GuiButton[6];

    public GuiCraftingStart(GuiBase parent, GridStackItem stack, Container container, int w, int h) {
        super(container, w, h);
        this.parent = parent;
        this.stack = stack;
    }

    public GuiCraftingStart(GuiGrid parent, EntityPlayer player, GridStackItem stack) {
        this(parent, stack, new ContainerCraftingSettings(player, stack.getStack()), 172, 99);
    }

    protected String getStartButtonText() {
        return GuiCraftingStart.t("misc.refinedstorage:start", new Object[0]);
    }

    protected String getTitle() {
        return GuiCraftingStart.t("container.crafting", new Object[0]);
    }

    protected String getTexture() {
        return "gui/crafting_settings.png";
    }

    protected int[] getIncrements() {
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    protected int getAmount() {
        return 1;
    }

    protected Tuple<Integer, Integer> getAmountPos() {
        return new Tuple((Object)8, (Object)51);
    }

    protected Tuple<Integer, Integer> getIncrementButtonPos(int x, int y) {
        return new Tuple((Object)(6 + x * 33), (Object)(y + (y == 0 ? 20 : 72)));
    }

    protected Tuple<Integer, Integer> getStartCancelPos() {
        return new Tuple((Object)114, (Object)33);
    }

    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    public void init(int x, int y) {
        int i;
        Tuple<Integer, Integer> pos = this.getStartCancelPos();
        this.startButton = this.addButton(x + (Integer)pos.func_76341_a(), y + (Integer)pos.func_76340_b(), 50, 20, this.getStartButtonText());
        this.cancelButton = this.addButton(x + (Integer)pos.func_76341_a(), y + (Integer)pos.func_76340_b() + 24, 50, 20, GuiCraftingStart.t("gui.cancel", new Object[0]));
        this.amountField = new GuiTextField(0, this.field_146289_q, x + (Integer)this.getAmountPos().func_76341_a(), y + (Integer)this.getAmountPos().func_76340_b(), 63, this.field_146289_q.field_78288_b);
        this.amountField.func_146185_a(false);
        this.amountField.func_146189_e(true);
        this.amountField.func_146180_a(String.valueOf(this.getAmount()));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_146205_d(false);
        this.amountField.func_146195_b(true);
        int[] increments = this.getIncrements();
        for (i = 0; i < 3; ++i) {
            pos = this.getIncrementButtonPos(i, 0);
            this.incrementButtons[i] = this.addButton(x + (Integer)pos.func_76341_a(), y + (Integer)pos.func_76340_b(), 30, 20, "+" + increments[i]);
        }
        for (i = 0; i < 3; ++i) {
            pos = this.getIncrementButtonPos(i, 1);
            this.incrementButtons[3 + i] = this.addButton(x + (Integer)pos.func_76341_a(), y + (Integer)pos.func_76340_b(), 30, 20, String.valueOf(increments[3 + i]));
        }
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture(this.getTexture());
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        this.amountField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.getTitle());
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.func_146983_a(keyCode) || !this.amountField.func_146201_a(character, keyCode)) {
            if (keyCode == 28) {
                this.startRequest();
            } else if (keyCode == 1) {
                this.close();
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.startButton.field_146127_k) {
            this.startRequest();
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        } else {
            for (GuiButton incrementButton : this.incrementButtons) {
                if (incrementButton.field_146127_k != button.field_146127_k) continue;
                Integer oldAmount = Ints.tryParse((String)this.amountField.func_146179_b());
                if (oldAmount == null) {
                    oldAmount = 0;
                }
                int newAmount = Integer.parseInt(incrementButton.field_146126_j);
                newAmount = !this.canAmountGoNegative() ? Math.max(1, (oldAmount == 1 && newAmount != 1 ? 0 : oldAmount) + newAmount) : oldAmount + newAmount;
                this.amountField.func_146180_a(String.valueOf(newAmount));
                break;
            }
        }
    }

    protected void startRequest() {
        Integer quantity = Ints.tryParse((String)this.amountField.func_146179_b());
        if (quantity != null && quantity > 0) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingPreview(this.stack.getHash(), quantity));
            this.startButton.field_146124_l = false;
        }
    }

    protected void close() {
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    public GuiBase getParent() {
        return this.parent;
    }
}

