/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerReaderWriter;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.Scrollbar;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterChannelAdd;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterChannelRemove;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiReaderWriter
extends GuiBase {
    public static List<String> CHANNELS = Collections.emptyList();
    private static final int VISIBLE_ROWS = 4;
    private static final int ITEM_WIDTH = 143;
    private static final int ITEM_HEIGHT = 18;
    private GuiButton add;
    private GuiButton remove;
    private GuiTextField name;
    private IReaderWriter readerWriter;
    private int itemSelected = -1;
    private int itemSelectedX = -1;
    private int itemSelectedY = -1;

    public GuiReaderWriter(ContainerReaderWriter container, IReaderWriter readerWriter) {
        super(container, 176, 209);
        this.readerWriter = readerWriter;
        this.scrollbar = new Scrollbar(157, 39, 12, 71);
    }

    @Override
    public void init(int x, int y) {
        this.add = this.addButton(x + 128, y + 15, 20, 20, "+");
        this.remove = this.addButton(x + 150, y + 15, 20, 20, "-");
        this.name = new GuiTextField(0, this.field_146289_q, x + 8 + 1, y + 20 + 1, 107, this.field_146289_q.field_78288_b);
        this.name.func_146185_a(false);
        this.name.func_146189_e(true);
        this.name.func_146193_g(0xFFFFFF);
        this.name.func_146205_d(true);
        this.name.func_146195_b(false);
        this.updateSelection(this.readerWriter.getChannelParameter().getValue());
    }

    @Override
    public void update(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 4);
        this.scrollbar.setMaxOffset(this.getRows() - 4);
        if (this.itemSelected >= this.getChannels().size()) {
            this.itemSelected = -1;
        }
    }

    private int getRows() {
        return this.getChannels().size();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/readerwriter.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.itemSelectedX != -1 && this.itemSelectedY != -1 && this.itemSelected >= 0 && this.itemSelected < this.getChannels().size()) {
            this.drawTexture(x + this.itemSelectedX, y + this.itemSelectedY, 0, 216, 143, 18);
        }
        this.name.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiReaderWriter.t(this.readerWriter.getTitle(), new Object[0]));
        this.drawString(7, 115, GuiReaderWriter.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 39;
        int item = this.scrollbar.getOffset();
        for (int i = 0; i < 4; ++i) {
            if (item < this.getChannels().size()) {
                if (item == this.itemSelected) {
                    this.itemSelectedX = x;
                    this.itemSelectedY = y;
                }
                float scale = 0.5f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(GuiReaderWriter.calculateOffsetOnScale(x + 5, scale), GuiReaderWriter.calculateOffsetOnScale(y + 7, scale), this.getChannels().get(item));
                GlStateManager.func_179121_F();
                y += 18;
            }
            ++item;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.name.func_146192_a(mouseX, mouseY, mouseButton);
        int itemSelectedOld = this.itemSelected;
        this.itemSelected = -1;
        if (mouseButton == 0 && this.inBounds(8, 39, 144, 73, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            int item = this.scrollbar.getOffset();
            for (int i = 0; i < 4; ++i) {
                int ix = 8;
                int iy = 39 + i * 18;
                if (!this.inBounds(ix, iy, 143, 18, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || item + i >= this.getChannels().size()) continue;
                this.itemSelected = item + i;
                TileDataManager.setParameter(this.readerWriter.getChannelParameter(), this.getChannels().get(this.itemSelected));
            }
        }
        if (itemSelectedOld != -1 && this.itemSelected == -1) {
            TileDataManager.setParameter(this.readerWriter.getChannelParameter(), "");
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 211) {
            this.sendRemove();
        } else if (this.name.func_146206_l() && keyCode == 28) {
            this.sendAdd();
        } else if (this.func_146983_a(keyCode) || !this.name.func_146201_a(character, keyCode)) {
            super.func_73869_a(character, keyCode);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.add) {
            this.sendAdd();
        } else if (button == this.remove) {
            this.sendRemove();
        }
    }

    private void sendAdd() {
        String name = this.name.func_146179_b().trim();
        if (!name.isEmpty()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageReaderWriterChannelAdd(name));
        }
    }

    private void sendRemove() {
        String name = this.name.func_146179_b().trim();
        if (!name.isEmpty()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageReaderWriterChannelRemove(name));
        }
    }

    public void updateSelection(String channel) {
        this.itemSelected = this.getChannels().indexOf(channel);
        this.name.func_146180_a(this.itemSelected != -1 ? this.getChannels().get(this.itemSelected) : "");
    }

    private List<String> getChannels() {
        return this.readerWriter.isConnected() ? CHANNELS : Collections.emptyList();
    }
}

