/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ItemStackListOredicted
implements IItemStackList {
    private IItemStackList underlyingList;
    private ArrayListMultimap<Integer, ItemStack> stacks = ArrayListMultimap.create();

    private ItemStackListOredicted() {
    }

    public ItemStackListOredicted(IItemStackList list) {
        this.underlyingList = list;
        this.initOreDict();
    }

    private void initOreDict() {
        for (ItemStack stack : this.underlyingList.getStacks()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                this.stacks.put((Object)id, (Object)stack);
            }
        }
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size) {
        this.underlyingList.add(stack, size);
        ItemStack internalStack = this.underlyingList.get(stack);
        if (internalStack != null && internalStack.field_77994_a == stack.field_77994_a) {
            for (int id : OreDictionary.getOreIDs((ItemStack)internalStack)) {
                this.stacks.put((Object)id, (Object)internalStack);
            }
        }
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack, int size, boolean removeIfReachedZero) {
        boolean rvalue = this.underlyingList.remove(stack, size, removeIfReachedZero);
        if (removeIfReachedZero) {
            Set ids = Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).boxed().collect(Collectors.toSet());
            this.localClean(ids.stream().flatMap(id -> this.stacks.get(id).stream().map(s -> Pair.of((Object)id, (Object)s))).collect(Collectors.toList()));
        }
        return rvalue;
    }

    @Override
    public boolean trackedRemove(@Nonnull ItemStack stack, int size, boolean removeIfReachedZero) {
        boolean rvalue = this.underlyingList.trackedRemove(stack, size, removeIfReachedZero);
        if (removeIfReachedZero) {
            Set ids = Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).boxed().collect(Collectors.toSet());
            this.localClean(ids.stream().flatMap(id -> this.stacks.get(id).stream().map(s -> Pair.of((Object)id, (Object)s))).collect(Collectors.toList()));
        }
        return rvalue;
    }

    @Override
    public List<ItemStack> getRemoveTracker() {
        return this.underlyingList.getRemoveTracker();
    }

    @Override
    public void undo() {
        this.underlyingList.getRemoveTracker().forEach(this::add);
        this.underlyingList.getRemoveTracker().clear();
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        ItemStack exact = this.underlyingList.get(stack, flags & 0xFFFFFFF7);
        if (exact == null && (flags & 8) == 8) {
            int[] ids;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                List stacks = this.stacks.get((Object)id);
                if (stacks == null || stacks.isEmpty()) continue;
                int i = 0;
                ItemStack returnStack = (ItemStack)stacks.get(i++);
                while (returnStack.field_77994_a == 0 && i < stacks.size()) {
                    returnStack = (ItemStack)stacks.get(i++);
                }
                if (returnStack.field_77994_a == 0) continue;
                return returnStack;
            }
        }
        return exact;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        return this.underlyingList.get(hash);
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.underlyingList.clear();
    }

    private void localClean(Collection<Map.Entry<Integer, ItemStack>> entries) {
        List<Map.Entry> toRemove = entries.stream().filter(entry -> ((ItemStack)entry.getValue()).field_77994_a <= 0).collect(Collectors.toList());
        toRemove.forEach(entry -> this.stacks.remove(entry.getKey(), entry.getValue()));
    }

    @Override
    public void clean() {
        this.localClean(this.stacks.entries());
        this.underlyingList.clean();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getStacks() {
        return this.underlyingList.getStacks();
    }

    @Override
    @Nonnull
    public IItemStackList copy() {
        ItemStackListOredicted newList = new ItemStackListOredicted();
        newList.underlyingList = this.underlyingList.copy();
        for (Map.Entry entry : this.stacks.entries()) {
            newList.stacks.put(entry.getKey(), entry.getValue());
        }
        return newList;
    }

    @Override
    @Nonnull
    public IItemStackList getOredicted() {
        return this;
    }
}

