/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackList
implements IFluidStackList {
    private ArrayListMultimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();
    private List<FluidStack> removeTracker = new LinkedList<FluidStack>();

    @Override
    public void add(FluidStack stack) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount += stack.amount;
            return;
        }
        this.stacks.put((Object)stack.getFluid(), (Object)stack.copy());
    }

    @Override
    public boolean remove(@Nonnull FluidStack stack, int size, boolean removeIfReachedZero) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            boolean success;
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount -= size;
            boolean bl = success = otherStack.amount >= 0;
            if (otherStack.amount <= 0 && removeIfReachedZero) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean trackedRemove(@Nonnull FluidStack stack, int size, boolean removeIfReachedZero) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            boolean success;
            if (otherStack.amount <= 0 || !stack.isFluidEqual(otherStack)) continue;
            FluidStack removed = new FluidStack(otherStack.getFluid(), Math.min(size, otherStack.amount));
            this.removeTracker.add(removed);
            otherStack.amount -= size;
            boolean bl = success = otherStack.amount >= 0;
            if (otherStack.amount <= 0 && removeIfReachedZero) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public void undo() {
        this.removeTracker.forEach(this::add);
        this.removeTracker.clear();
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack get(int hash) {
        for (FluidStack stack : this.stacks.values()) {
            if (API.instance().getFluidStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public void clean() {
        List<FluidStack> toRemove = this.stacks.values().stream().filter(stack -> stack.amount <= 0).collect(Collectors.toList());
        toRemove.forEach(stack -> this.stacks.remove((Object)stack.getFluid(), stack));
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IFluidStackList copy() {
        FluidStackList list = new FluidStackList();
        for (FluidStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.getFluid(), (Object)stack.copy());
        }
        return list;
    }

    public String toString() {
        return this.stacks.toString();
    }
}

