/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.item;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ItemStorageCache
implements IItemStorageCache {
    private INetworkMaster network;
    private List<IItemStorage> storages = Collections.synchronizedList(new ArrayList());
    private IItemStackList list = API.instance().createItemStackList();

    public ItemStorageCache(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IItemStorageProvider).forEach(node -> ((IItemStorageProvider)((Object)node)).addItemStorages(this.storages));
        this.list.clear();
        for (IItemStorage storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (ItemStack stack : storage.getStacks()) {
                if (stack == null) continue;
                this.add(stack, stack.field_77994_a, true);
            }
        }
        for (ICraftingPattern pattern : this.network.getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                ItemStack patternStack = output.func_77946_l();
                patternStack.field_77994_a = 0;
                this.add(patternStack, patternStack.field_77994_a, true);
            }
        }
        this.network.sendItemStorageToClient();
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size, boolean rebuilding) {
        this.list.add(stack, size);
        if (!rebuilding) {
            this.network.sendItemStorageDeltaToClient(stack, size);
        }
    }

    @Override
    public void remove(@Nonnull ItemStack stack, int size) {
        if (this.list.remove(stack, size, !this.network.hasPattern(stack))) {
            this.network.sendItemStorageDeltaToClient(stack, -size);
        }
    }

    @Override
    public IItemStackList getList() {
        return this.list;
    }

    @Override
    public List<IItemStorage> getStorages() {
        return this.storages;
    }
}

