/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.fluid;

import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageCache
implements IFluidStorageCache {
    private INetworkMaster network;
    private List<IFluidStorage> storages = Collections.synchronizedList(new ArrayList());
    private IFluidStackList list = API.instance().createFluidStackList();

    public FluidStorageCache(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IFluidStorageProvider).forEach(node -> ((IFluidStorageProvider)((Object)node)).addFluidStorages(this.storages));
        this.list.clear();
        for (IFluidStorage storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (FluidStack stack : storage.getStacks()) {
                this.add(stack, true);
            }
        }
        this.network.sendFluidStorageToClient();
    }

    @Override
    public void add(@Nonnull FluidStack stack, boolean rebuilding) {
        this.list.add(stack);
        if (!rebuilding) {
            this.network.sendFluidStorageDeltaToClient(stack, stack.amount);
        }
    }

    @Override
    public void remove(@Nonnull FluidStack stack) {
        if (this.list.remove(stack, true)) {
            this.network.sendFluidStorageDeltaToClient(stack, -stack.amount);
        }
    }

    @Override
    public IFluidStackList getList() {
        return this.list;
    }

    @Override
    public List<IFluidStorage> getStorages() {
        return this.storages;
    }
}

