/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.grid.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessGrid;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreviewResponse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private INetworkMaster network;

    public ItemGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void onExtract(int hash, int flags, EntityPlayerMP player) {
        ItemStack took;
        ItemStack item = this.network.getItemStorageCache().getList().get(hash);
        if (item == null) {
            return;
        }
        int itemSize = item.field_77994_a;
        int maxItemSize = item.func_77973_b().getItemStackLimit(item);
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? held != null && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.field_77994_a + 1 > held.func_77976_d()) : player.field_71071_by.func_70445_o() != null) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        if ((took = this.network.extractItem(item, size = Math.min(size, maxItemSize), true)) != null) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)true) == null) {
                    took = this.network.extractItem(item, size, false);
                    ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                }
            } else {
                took = this.network.extractItem(item, size, false);
                if (single && held != null) {
                    ++held.field_77994_a;
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
            if (networkItem != null && networkItem instanceof NetworkItemWirelessGrid) {
                ((NetworkItemWirelessGrid)networkItem).drainEnergy(RS.INSTANCE.config.wirelessGridExtractUsage);
            }
        }
    }

    @Override
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack) {
        ItemStack remainder = this.network.insertItem(stack, stack.field_77994_a, false);
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null && networkItem instanceof NetworkItemWirelessGrid) {
            ((NetworkItemWirelessGrid)networkItem).drainEnergy(RS.INSTANCE.config.wirelessGridInsertUsage);
        }
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        int size;
        if (player.field_71071_by.func_70445_o() == null) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int n = size = single ? 1 : stack.field_77994_a;
        if (single) {
            if (this.network.insertItem(stack, size, true) == null) {
                this.network.insertItem(stack, size, false);
                stack.field_77994_a -= size;
                if (stack.field_77994_a == 0) {
                    player.field_71071_by.func_70437_b(null);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(this.network.insertItem(stack, size, false));
        }
        player.func_71113_k();
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null && networkItem instanceof NetworkItemWirelessGrid) {
            ((NetworkItemWirelessGrid)networkItem).drainEnergy(RS.INSTANCE.config.wirelessGridInsertUsage);
        }
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, int hash, int quantity) {
        ItemStack stack = this.network.getItemStorageCache().getList().get(hash);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                CraftingTask task = new CraftingTask(this.network, stack, this.network.getPattern(stack), quantity);
                task.calculate();
                RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(task.getPreviewStacks(), hash, quantity), player);
            }, "RS crafting calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(int hash, int quantity) {
        if (quantity <= 0) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getList().get(hash);
        if (stack != null) {
            CraftingTask task = new CraftingTask(this.network, stack, this.network.getPattern(stack), quantity);
            task.calculate();
            task.getMissing().clear();
            this.network.addCraftingTask(task);
        }
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, int id) {
        if (id >= 0 && id < this.network.getCraftingTasks().size()) {
            this.network.cancelCraftingTask(this.network.getCraftingTasks().get(id));
        } else if (id == -1) {
            for (ICraftingTask task : this.network.getCraftingTasks()) {
                this.network.cancelCraftingTask(task);
            }
        }
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null && networkItem instanceof NetworkItemWirelessCraftingMonitor) {
            ((NetworkItemWirelessCraftingMonitor)networkItem).drainEnergy(id == -1 ? RS.INSTANCE.config.wirelessCraftingMonitorCancelAllUsage : RS.INSTANCE.config.wirelessCraftingMonitorCancelUsage);
        }
    }
}

