/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.registry;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.registry.ICraftingTaskFactory;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStep;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CraftingTaskFactory
implements ICraftingTaskFactory {
    public static final String ID = "normal";

    @Override
    @Nonnull
    public ICraftingTask create(World world, INetworkMaster network, @Nullable ItemStack stack, ICraftingPattern pattern, int quantity, @Nullable NBTTagCompound tag) {
        if (tag != null) {
            NBTTagList stepsList = tag.func_150295_c("Steps", 10);
            ArrayList<ICraftingStep> steps = new ArrayList<ICraftingStep>();
            for (int i = 0; i < stepsList.func_74745_c(); ++i) {
                NBTTagCompound stepTag = stepsList.func_150305_b(i);
                ICraftingStep step = CraftingStep.toCraftingStep(stepTag, network);
                if (step == null) continue;
                steps.add(step);
            }
            NBTTagList toInsertList = tag.func_150295_c("ToInsertItems", 10);
            ArrayDeque<ItemStack> toInsert = new ArrayDeque<ItemStack>();
            for (int i = 0; i < toInsertList.func_74745_c(); ++i) {
                ItemStack insertStack = ItemStack.func_77949_a((NBTTagCompound)toInsertList.func_150305_b(i));
                if (insertStack == null) continue;
                toInsert.add(insertStack);
            }
            IFluidStackList toTakeFluids = RSUtils.readFluidStackList(tag.func_150295_c("ToTakeFluids", 10));
            NBTTagList toInsertFluidsList = tag.func_150295_c("ToInsertFluids", 10);
            ArrayDeque<FluidStack> toInsertFluids = new ArrayDeque<FluidStack>();
            for (int i = 0; i < toInsertFluidsList.func_74745_c(); ++i) {
                FluidStack tookStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)toInsertFluidsList.func_150305_b(i));
                if (tookStack == null) continue;
                toInsertFluids.add(tookStack);
            }
            return new CraftingTask(network, stack, pattern, quantity, steps, toInsert, toTakeFluids, toInsertFluids);
        }
        return new CraftingTask(network, stack, pattern, quantity);
    }
}

