/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.network;

import cofh.api.energy.EnergyStorage;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.grid.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageCache;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public interface INetworkMaster {
    public EnergyStorage getEnergy();

    public int getEnergyUsage();

    public BlockPos getPosition();

    public boolean canRun();

    public INetworkNodeGraph getNodeGraph();

    public IItemGridHandler getItemGridHandler();

    public IFluidGridHandler getFluidGridHandler();

    public INetworkItemHandler getNetworkItemHandler();

    public IItemStorageCache getItemStorageCache();

    public IFluidStorageCache getFluidStorageCache();

    public List<ICraftingTask> getCraftingTasks();

    public void addCraftingTask(@Nonnull ICraftingTask var1);

    public void cancelCraftingTask(@Nonnull ICraftingTask var1);

    public List<ICraftingPattern> getPatterns();

    public void rebuildPatterns();

    public List<ICraftingPattern> getPatterns(ItemStack var1, int var2);

    @Nullable
    public ICraftingPattern getPattern(ItemStack var1, int var2);

    @Nullable
    public ICraftingPattern getPattern(ItemStack var1, int var2, IItemStackList var3);

    default public ICraftingPattern getPattern(ItemStack pattern) {
        return this.getPattern(pattern, 3);
    }

    default public boolean hasPattern(ItemStack stack) {
        return this.getPattern(stack) != null;
    }

    default public ICraftingTask createCraftingTask(@Nullable ItemStack stack, ICraftingPattern pattern, int quantity) {
        return API.instance().getCraftingTaskRegistry().getFactory(pattern.getId()).create(this.getNetworkWorld(), this, stack, pattern, quantity, null);
    }

    public void scheduleCraftingTask(ItemStack var1, int var2, int var3);

    public void sendItemStorageToClient();

    public void sendItemStorageToClient(EntityPlayerMP var1);

    public void sendItemStorageDeltaToClient(ItemStack var1, int var2);

    public void sendFluidStorageToClient();

    public void sendFluidStorageToClient(EntityPlayerMP var1);

    public void sendFluidStorageDeltaToClient(FluidStack var1, int var2);

    public void markCraftingMonitorForUpdate();

    public void sendCraftingMonitorUpdate();

    public void sendCraftingMonitorUpdate(EntityPlayerMP var1);

    @Nullable
    public IReaderWriterChannel getReaderWriterChannel(String var1);

    public void addReaderWriterChannel(String var1);

    public void removeReaderWriterChannel(String var1);

    public void sendReaderWriterChannelUpdate();

    public void sendReaderWriterChannelUpdate(EntityPlayerMP var1);

    @Nullable
    public ItemStack insertItem(@Nonnull ItemStack var1, int var2, boolean var3);

    @Nullable
    public ItemStack extractItem(@Nonnull ItemStack var1, int var2, int var3, boolean var4);

    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        return this.extractItem(stack, size, 3, simulate);
    }

    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack var1, int var2, boolean var3);

    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack var1, int var2, int var3, boolean var4);

    default public FluidStack extractFluid(FluidStack stack, int size, boolean simulate) {
        return this.extractFluid(stack, size, 2, simulate);
    }

    public World getNetworkWorld();
}

