/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.inventory.server.InventoryWrapperAH;
import mob_grinding_utils.tile.FluidTankTile;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAbsorptionHopper
extends TileEntityInventoryHelper
implements ITickable {
    public FluidTankTile tank;
    private IItemHandler itemHandler;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public EnumStatus[] status = new EnumStatus[]{EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE};

    public TileEntityAbsorptionHopper() {
        super(17);
        this.tank = new FluidTankTile(null, 16000);
        this.tank.setTileEntity(this);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        EnumStatus[] old = new EnumStatus[]{this.status[0], this.status[1], this.status[2], this.status[3], this.status[4], this.status[5]};
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        this.tank.onContentsChanged();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (old[facing.ordinal()] == this.status[facing.ordinal()]) continue;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        return this.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.status[0] = EnumStatus.values()[tagCompound.func_74771_c("down")];
        this.status[1] = EnumStatus.values()[tagCompound.func_74771_c("up")];
        this.status[2] = EnumStatus.values()[tagCompound.func_74771_c("north")];
        this.status[3] = EnumStatus.values()[tagCompound.func_74771_c("south")];
        this.status[4] = EnumStatus.values()[tagCompound.func_74771_c("west")];
        this.status[5] = EnumStatus.values()[tagCompound.func_74771_c("east")];
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("down", (byte)this.status[0].ordinal());
        tagCompound.func_74774_a("up", (byte)this.status[1].ordinal());
        tagCompound.func_74774_a("north", (byte)this.status[2].ordinal());
        tagCompound.func_74774_a("south", (byte)this.status[3].ordinal());
        tagCompound.func_74774_a("west", (byte)this.status[4].ordinal());
        tagCompound.func_74774_a("east", (byte)this.status[5].ordinal());
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public EnumStatus getSideStatus(EnumFacing side) {
        return this.status[side.ordinal()];
    }

    public void toggleMode(EnumFacing side) {
        switch (this.status[side.ordinal()]) {
            case STATUS_NONE: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_ITEM;
                break;
            }
            case STATUS_OUTPUT_ITEM: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_FLUID;
                break;
            }
            case STATUS_OUTPUT_FLUID: {
                this.status[side.ordinal()] = EnumStatus.STATUS_NONE;
            }
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IFluidTankProperties[] tankProperties;
            TileEntity tile;
            if (this.status[facing.ordinal()] == EnumStatus.STATUS_OUTPUT_ITEM) {
                ItemStack stack;
                tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                        for (int i = 0; i < this.func_70302_i_(); ++i) {
                            if (this.func_70301_a(i) == null || i == 0) continue;
                            stack = this.func_70301_a(i).func_77946_l();
                            stack.field_77994_a = 1;
                            ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                            if (stack1 != null && stack1.field_77994_a != 0) continue;
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(i, 1), (boolean)false);
                            this.func_70296_d();
                        }
                    }
                } else if (tile != null && tile instanceof IInventory) {
                    IInventory iinventory = (IInventory)tile;
                    if (this.isInventoryFull(iinventory, facing)) break;
                    if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                        for (int i = 0; i < this.func_70302_i_(); ++i) {
                            if (this.func_70301_a(i) == null || i == 0) continue;
                            stack = this.func_70301_a(i).func_77946_l();
                            ItemStack stack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(iinventory, this.func_70298_a(i, 1), facing.func_176734_d());
                            if (stack1 == null || stack1.field_77994_a == 0) {
                                iinventory.func_70296_d();
                                continue;
                            }
                            this.func_70299_a(i, stack);
                        }
                    }
                }
            }
            if (this.status[facing.ordinal()] != EnumStatus.STATUS_OUTPUT_FLUID || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
            IFluidHandler recepticle = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            for (IFluidTankProperties properties : tankProperties = recepticle.getTankProperties()) {
                if (!properties.canFill() || properties.getCapacity() <= 0) continue;
                FluidStack contents = properties.getContents();
                if (this.tank.getFluid() == null || contents != null && (contents.amount > properties.getCapacity() - 100 || !contents.containsFluid(new FluidStack(this.tank.getFluid(), 0)))) continue;
                recepticle.fill(this.tank.drain(new FluidStack(this.tank.getFluid(), 100), true), true);
                this.func_70296_d();
            }
        }
        if (this.field_145850_b.func_82737_E() % 3L == 0L) {
            if (!this.isInventoryFull((IInventory)this, null)) {
                this.captureDroppedItems();
            }
            if (this.tank.getFluid() == null || this.tank.getFluid().containsFluid(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 0))) {
                this.captureDroppedXP();
            }
        }
    }

    @Override
    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
    }

    public boolean captureDroppedItems() {
        for (EntityItem entityitem : this.getCaptureItems(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5)) {
            if (!TileEntityAbsorptionHopper.putDropInInventoryAllSlots((IInventory)this, entityitem)) continue;
            return true;
        }
        return false;
    }

    public List<EntityItem> getCaptureItems(World world, double x, double y, double z) {
        int modifier = 0;
        if (this.hasUpgrade()) {
            modifier = this.inventory[0].field_77994_a;
        }
        return world.func_175647_a(EntityItem.class, new AxisAlignedBB(x - 3.5 - (double)modifier, y - 3.5 - (double)modifier, z - 3.5 - (double)modifier, x + 3.5 + (double)modifier, y + 3.5 + (double)modifier, z + 3.5 + (double)modifier), EntitySelectors.field_94557_a);
    }

    public boolean captureDroppedXP() {
        Iterator<EntityXPOrb> iterator = this.getCaptureXP(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5).iterator();
        if (iterator.hasNext()) {
            EntityXPOrb entity = iterator.next();
            int xpAmount = entity.func_70526_d();
            if (this.tank.getFluidAmount() < this.tank.getCapacity() - xpAmount * 20) {
                this.tank.fill(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), xpAmount * 20), true);
                entity.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public List<EntityXPOrb> getCaptureXP(World world, double x, double y, double z) {
        int modifier = 0;
        if (this.hasUpgrade()) {
            modifier = this.inventory[0].field_77994_a;
        }
        return world.func_175647_a(EntityXPOrb.class, new AxisAlignedBB(x - 3.5 - (double)modifier, y - 3.5 - (double)modifier, z - 3.5 - (double)modifier, x + 3.5 + (double)modifier, y + 3.5 + (double)modifier, z + 3.5 + (double)modifier), EntitySelectors.field_94557_a);
    }

    private boolean hasUpgrade() {
        return this.inventory[0] != null && this.inventory[0].func_77973_b() == MobGrindingUtils.ABSORPTION_UPGRADE;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)index);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot != 0;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (itemstack1 != null && itemstack1.field_77994_a == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null && !(inventoryIn instanceof TileEntityAbsorptionHopper) && inventoryIn.func_94041_b(0, stack.func_77946_l())) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != null && stack.field_77994_a > 0; ++k) {
                stack = TileEntityAbsorptionHopper.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
                stack = TileEntityAbsorptionHopper.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    public static boolean putDropInInventoryAllSlots(IInventory inventoryIn, EntityItem itemIn) {
        boolean flag = false;
        if (itemIn == null || inventoryIn instanceof TileEntityAbsorptionHopper && inventoryIn.func_94041_b(0, itemIn.func_92059_d().func_77946_l())) {
            return false;
        }
        ItemStack itemstack = itemIn.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(inventoryIn, itemstack, null);
        if (itemstack1 != null && itemstack1.field_77994_a != 0) {
            itemIn.func_92058_a(itemstack1);
        } else {
            flag = true;
            itemIn.func_70106_y();
        }
        return flag;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !inventoryIn.func_94041_b(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (TileEntityAbsorptionHopper.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            boolean flag = false;
            if (itemstack == null) {
                int max2 = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max2 >= stack.field_77994_a) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = null;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max2));
                }
                flag = true;
            } else if (TileEntityAbsorptionHopper.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.field_77994_a) {
                int i = max - itemstack.field_77994_a;
                int j = Math.min(stack.field_77994_a, i);
                stack.field_77994_a -= j;
                itemstack.field_77994_a += j;
                flag = j > 0;
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.field_77994_a > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    protected IItemHandler createUnSidedHandler() {
        return new InventoryWrapperAH((IInventory)this);
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().amount / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum EnumStatus implements IStringSerializable
    {
        STATUS_NONE("none"),
        STATUS_OUTPUT_ITEM("item"),
        STATUS_OUTPUT_FLUID("fluid");

        private final String name;

        private EnumStatus(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

