/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.item;

import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ChamMultiItem<T extends Enum<T>>
extends Item
implements IItemMeshMapper {
    private final Class<T> clazz;
    private final IntFunction<T> metaLookup;

    public ChamMultiItem(Class<T> clazz, IntFunction<T> metaLookup) {
        this.clazz = clazz;
        this.metaLookup = metaLookup;
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77667_c(ItemStack itemStack) {
        Enum material = (Enum)this.metaLookup.apply(itemStack.func_77960_j());
        return super.func_77658_a() + "." + ((IItemEnum)((Object)material)).getUnlocalizedName();
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            list.add(new ItemStack(item, 1, ((IItemEnum)((Object)entry)).getMetadata()));
        }
    }

    @Override
    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName().toString() + '_' + ((IStringSerializable)entry).func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, ((IItemEnum)((Object)entry)).getMetadata()), (Object)location));
        }
        return mappings;
    }
}

