/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.dimension.otherworld;

import elucent.roots.RegistryManager;
import elucent.roots.block.BlockLogBase;
import elucent.roots.dimension.RootsBiome;
import elucent.roots.dimension.otherworld.GenerationUtil;
import elucent.roots.dimension.otherworld.RootsStructure;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureAzurePineTree
extends RootsStructure {
    static Random random = new Random();

    public static void generateTree(World world, int x, int y, int z) {
        int i;
        int height = random.nextInt(8) + 10;
        boolean canSpawn = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == RegistryManager.needleGrass;
        for (i = 0; i < height; ++i) {
            if (world.func_175623_d(new BlockPos(x, y + i, z)) || world.func_180495_p(new BlockPos(x, y + i, z)).func_177230_c() == RegistryManager.leavesAzurepine) continue;
            canSpawn = false;
        }
        if (canSpawn) {
            for (i = 0; i < height; ++i) {
                if (i > height / 4) {
                    if (i % 2 == 0) {
                        float radius = 6.5f * (0.5f + 0.33333334f * ((float)height - (float)i) / (float)height);
                        GenerationUtil.generateDiscWithDecay(world, x, y + i, z, radius, 0.15f, RegistryManager.leavesAzurepine.func_176223_P());
                        GenerationUtil.generateDiscWithDecay(world, x, y + i + 1, z, radius - 2.0f, 0.15f, RegistryManager.leavesAzurepine.func_176223_P());
                        GenerationUtil.fillBox(world, x - (int)(radius - 2.0f), y + i, z, x + 1 + (int)(radius - 2.0f), y + i + 1, z + 1, RegistryManager.logWildwood.func_176223_P().func_177226_a((IProperty)BlockLogBase.field_176298_M, (Comparable)EnumFacing.Axis.X));
                        GenerationUtil.fillBox(world, x, y + i, z - (int)(radius - 2.0f), x + 1, y + i + 1, z + (int)(radius - 2.0f) + 1, RegistryManager.logWildwood.func_176223_P().func_177226_a((IProperty)BlockLogBase.field_176298_M, (Comparable)EnumFacing.Axis.Z));
                    }
                    if (i == height - 1) {
                        for (int j = 5; j > 0; --j) {
                            GenerationUtil.generateDisc(world, x, y + i + (5 - j) + 1, z, (float)j / 3.0f, RegistryManager.leavesAzurepine.func_176223_P());
                        }
                    }
                }
                world.func_175656_a(new BlockPos(x, y + i, z), RegistryManager.logWildwood.func_176223_P().func_177226_a((IProperty)BlockLogBase.field_176298_M, (Comparable)EnumFacing.Axis.Y));
            }
        }
    }

    public StructureAzurePineTree(float chance, int count) {
        super(chance, count);
    }

    @Override
    public void generate(World world, int x, int z, int[][] heights, int[][] bottoms, RootsBiome[][] biomes, float[][] coeffs) {
        if (random.nextFloat() < this.chancePerChunk) {
            for (int i = 0; i < this.numPerChunk; ++i) {
                int zz;
                int xx = random.nextInt(16);
                if (!biomes[0][0].equals(biomes[xx][zz = random.nextInt(16)])) continue;
                StructureAzurePineTree.generateTree(world, x * 16 + xx, heights[xx][zz], z * 16 + zz);
            }
        }
    }
}

