/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.dimension;

import elucent.roots.RegistryManager;
import elucent.roots.Util;
import elucent.roots.dimension.OtherworldBiomes;
import elucent.roots.dimension.RootsBiome;
import elucent.roots.entity.EntityDeer;
import elucent.roots.entity.EntityDireWolf;
import elucent.roots.util.NoiseGenUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;

public class OtherworldChunkGenerator
implements IChunkGenerator {
    Random random = new Random();
    World world;
    List<Biome.SpawnListEntry> passiveCreatures = new ArrayList<Biome.SpawnListEntry>();
    List<RootsBiome> biomeOrder = new ArrayList<RootsBiome>();

    public int getHeight(float biomeCoeff, float islandCoeff, int x, int y) {
        RootsBiome lower = this.biomeOrder.get(Math.min(this.biomeOrder.size() - 1, (int)Math.floor(biomeCoeff)));
        RootsBiome higher = this.biomeOrder.get(Math.min(this.biomeOrder.size() - 1, (int)Math.ceil(biomeCoeff)));
        return (int)((1.0f - Util.fract(biomeCoeff)) * (float)lower.getTopNoise().getScaledNoiseAtPos(this.world.func_72905_C(), islandCoeff, x, y) + Util.fract(biomeCoeff) * (float)higher.getTopNoise().getScaledNoiseAtPos(this.world.func_72905_C(), islandCoeff, x, y));
    }

    public int getBottom(float biomeCoeff, float islandCoeff, int x, int y) {
        RootsBiome lower = this.biomeOrder.get(Math.min(this.biomeOrder.size() - 1, (int)Math.floor(biomeCoeff)));
        RootsBiome higher = this.biomeOrder.get(Math.min(this.biomeOrder.size() - 1, (int)Math.ceil(biomeCoeff)));
        return (int)((1.0f - Util.fract(biomeCoeff)) * (float)lower.getBottomNoise().getScaledNoiseAtPos(this.world.func_72905_C(), islandCoeff, x, y) + Util.fract(biomeCoeff) * (float)higher.getBottomNoise().getScaledNoiseAtPos(this.world.func_72905_C(), islandCoeff, x, y));
    }

    public OtherworldChunkGenerator(World world) {
        this.world = world;
        this.passiveCreatures.add(new Biome.SpawnListEntry(EntitySheep.class, 50, 5, 15));
        this.passiveCreatures.add(new Biome.SpawnListEntry(EntityWolf.class, 25, 5, 15));
        this.passiveCreatures.add(new Biome.SpawnListEntry(EntityDeer.class, 50, 5, 15));
        this.passiveCreatures.add(new Biome.SpawnListEntry(EntityDireWolf.class, 10, 5, 15));
        this.biomeOrder.add(OtherworldBiomes.biomeGlowingSands);
        this.biomeOrder.add(OtherworldBiomes.biomePlains);
        this.biomeOrder.add(OtherworldBiomes.biomeShrubland);
        this.biomeOrder.add(OtherworldBiomes.biomeWoods);
        this.biomeOrder.add(OtherworldBiomes.biomeDeepwood);
    }

    public float getIslandCoefficient(int x, int y) {
        return 2.0f * (NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 1) * 0.0078125f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 4) * 0.015625f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 10) * 0.03125f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 16) * 0.0625f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 32) * 0.125f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 50) * 0.25f + NoiseGenUtil.getOctave(this.world.func_72905_C(), x, y, 100) * 0.5f - 0.5f);
    }

    public RootsBiome getBiome(int x, int z) {
        double val = (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 60) * 0.5 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 150) * 1.0 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 300) * 1.5 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 500) * 2.0;
        int index = (int)Math.floor((val / 5.0 - (double)1.0E-4f) * (double)this.biomeOrder.size());
        return this.biomeOrder.get(index);
    }

    public float getBiomeCoeff(int x, int z) {
        double val = (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 60) * 0.5 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 150) * 1.0 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 300) * 1.5 + (double)NoiseGenUtil.getOctave(this.world.func_72905_C(), x, z, 500) * 2.0;
        return (float)((val / 5.0 - (double)1.0E-4f) * (double)this.biomeOrder.size());
    }

    public Chunk func_185932_a(int x, int z) {
        int j;
        int i;
        Chunk c = new Chunk(this.world, x, z);
        int[][] heights = new int[16][16];
        int[][] bottoms = new int[16][16];
        float[][] coeffs = new float[16][16];
        RootsBiome[][] biomes = new RootsBiome[16][16];
        float[][] biomeCoeffs = new float[16][16];
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                biomes[i][j] = this.getBiome(x * 16 + i, z * 16 + j);
                coeffs[i][j] = this.getIslandCoefficient(x * 16 + i, z * 16 + j);
                biomeCoeffs[i][j] = this.getBiomeCoeff(x * 16 + i, z * 16 + j);
                heights[i][j] = this.getHeight(biomeCoeffs[i][j], coeffs[i][j], x * 16 + i, z * 16 + j);
                bottoms[i][j] = this.getBottom(biomeCoeffs[i][j], coeffs[i][j], x * 16 + i, z * 16 + j);
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                int k;
                if (!((double)coeffs[i][j] >= -0.012)) continue;
                RootsBiome biome = biomes[i][j];
                if (biome == OtherworldBiomes.biomePlains || biome == OtherworldBiomes.biomeShrubland || biome == OtherworldBiomes.biomeWoods) {
                    for (k = bottoms[i][j]; k < heights[i][j]; ++k) {
                        if (k == heights[i][j] - 1) {
                            c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.otherworldGrass.func_176223_P());
                            continue;
                        }
                        if (k >= heights[i][j] - 4 && k < heights[i][j] - 1) {
                            c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.otherworldDirt.func_176223_P());
                            continue;
                        }
                        c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), Blocks.field_150348_b.func_176223_P());
                    }
                    continue;
                }
                if (biome == OtherworldBiomes.biomeDeepwood) {
                    for (k = bottoms[i][j]; k < heights[i][j]; ++k) {
                        if (k == heights[i][j] - 1) {
                            c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.needleGrass.func_176223_P());
                            continue;
                        }
                        if (k >= heights[i][j] - 4 && k < heights[i][j] - 1) {
                            c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.otherworldDirt.func_176223_P());
                            continue;
                        }
                        c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), Blocks.field_150348_b.func_176223_P());
                    }
                    continue;
                }
                if (biome != OtherworldBiomes.biomeGlowingSands) continue;
                for (k = bottoms[i][j]; k < heights[i][j]; ++k) {
                    if (k == heights[i][j] - 1) {
                        c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.glowSand.func_176223_P());
                        continue;
                    }
                    if (k >= heights[i][j] - 4 && k < heights[i][j] - 1) {
                        c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), RegistryManager.glowSand.func_176223_P());
                        continue;
                    }
                    c.func_177436_a(new BlockPos(x * 16 + i, k, z * 16 + j), Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        return c;
    }

    public void func_185931_b(int x, int z) {
        int i;
        int[][] heights = new int[16][16];
        int[][] bottoms = new int[16][16];
        float[][] coeffs = new float[16][16];
        RootsBiome[][] biomes = new RootsBiome[16][16];
        float[][] biomeCoeffs = new float[16][16];
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                biomes[i][j] = this.getBiome(x * 16 + i, z * 16 + j);
                coeffs[i][j] = this.getIslandCoefficient(x * 16 + i, z * 16 + j);
                biomeCoeffs[i][j] = this.getBiomeCoeff(x * 16 + i, z * 16 + j);
                heights[i][j] = this.getHeight(biomeCoeffs[i][j], coeffs[i][j], x * 16 + i, z * 16 + j);
                bottoms[i][j] = this.getBottom(biomeCoeffs[i][j], coeffs[i][j], x * 16 + i, z * 16 + j);
            }
        }
        for (i = 0; i < biomes[0][0].structures.size(); ++i) {
            biomes[0][0].structures.get(i).generate(this.world, x, z, heights, bottoms, biomes, coeffs);
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        this.world.field_73011_w.setAllowedSpawnTypes(true, true);
        if (creatureType == EnumCreatureType.CREATURE) {
            return this.passiveCreatures;
        }
        return new ArrayList<Biome.SpawnListEntry>();
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return new BlockPos(0, 0, 0);
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }
}

