/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigManager {
    public static Configuration config;
    public static int otherworldDimensionID;
    public static int oldRootDropChance;
    public static int verdantSprigDropChance;
    public static int infernalStemDropChance;
    public static int dragonsEyeDropChance;
    public static int berriesDropChance;
    public static boolean showTabletWave;
    public static String[] disabledComponents;
    public static int chargeTicks;
    public static int staffUses;
    public static int efficiencyBonus;
    public static int manaBarOffset;
    public static boolean disablePVP;
    public static int hungerTalismanTimer;
    public static int dischargeAmuletTimer;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        config.addCustomCategoryComment("client", "Settings that affect clientside graphical preferences.");
        config.addCustomCategoryComment("general", "Settings related to actual gameplay-affecting features.");
        oldRootDropChance = config.getInt("oldRootDropChance", "general", 40, 0, Short.MAX_VALUE, "Old Roots will drop from tall grass with a 1/oldRootDropChance probability.");
        verdantSprigDropChance = config.getInt("verdantSprigDropChance", "general", 30, 0, Short.MAX_VALUE, "Verdant Sprigs will drop from grown crops with a 1/verdantSprigDropChance probability.");
        infernalStemDropChance = config.getInt("infernalBulbDropChance", "general", 20, 0, Short.MAX_VALUE, "Infernal Bulbs will drop from nether wart with a 1/infernalBulbDropChance probability.");
        dragonsEyeDropChance = config.getInt("dragonsEyeDropChance", "general", 10, 0, Short.MAX_VALUE, "Dragon's Eyes will drop from chorus flowers with a 1/dragonsEyeDropChance probability.");
        berriesDropChance = config.getInt("berriesDropChance", "general", 25, 0, Short.MAX_VALUE, "Berries will drop from oak leaves with a 1/berriesDropChance probability.");
        showTabletWave = config.getBoolean("showTabletWave", "client", true, "Toggles the wave effect in the Runic Tablet GUI.");
        chargeTicks = config.getInt("staffChargeTicks", "general", 20, 1, Short.MAX_VALUE, "The number of ticks required to prepare a spell with a staff.");
        manaBarOffset = config.getInt("manaBarOffset", "client", 59, 0, Short.MAX_VALUE, "The number of pixels above the bottom of the screen that the mana bar should be rendered. If it's conflicting with a bar from another mod, raising it by 10 will normally position it right.");
        staffUses = config.getInt("staffUses", "general", 65, 0, Short.MAX_VALUE, "The number of uses an unmodified staff will have upon being crafted.");
        efficiencyBonus = config.getInt("efficiencyBonusUses", "general", 32, 0, Short.MAX_VALUE, "The number of additional uses each efficiency modifier gives.");
        disabledComponents = config.getStringList("disabledComponents", "general", new String[]{"<example>", "<another example>"}, "A string list of all disabled components. Valid component names include: \"allium\", \"apple\", \"azurebluet\", \"blueorchid\", \"chorus\", \"dandelion\", \"flareorchid\", \"lilac\", \"lilypad\", \"midnightbloom\", \"netherwart\", \"orangetulip\", \"oxeyedaisy\", \"peony\", \"pinktulip\", \"poisonouspotato\", \"poppy\", \"radiantdaisy\", \"redtulip\", \"rosebush\", \"sunflower\", \"whitetulip\"");
        disablePVP = config.getBoolean("disablePVP", "spells", false, "Whether or not damaging spells can affect players.");
        hungerTalismanTimer = config.getInt("hungerTalismanTimer", "general", 100, 1, Short.MAX_VALUE, "The cooldown (in ticks) of the hunger talisman.");
        dischargeAmuletTimer = config.getInt("dischargeAmuletTimer", "general", 100, 1, Short.MAX_VALUE, "The cooldown (in ticks) of the discharge amulet.");
        otherworldDimensionID = config.getInt("otherworldDimensionID", "general", 67, 0, Short.MAX_VALUE, "The dimension ID used for the otherworld dimension.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("roots")) {
            ConfigManager.load();
        }
    }
}

