/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.uv.UV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class VertexDataUtils {
    public static int getPositionElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (!format.func_177348_c(e).func_177374_g()) continue;
            return e;
        }
        return -1;
    }

    public static int getNormalElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (format.func_177348_c(e).func_177375_c() != VertexFormatElement.EnumUsage.NORMAL) continue;
            return e;
        }
        return -1;
    }

    public static int getUVElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (format.func_177348_c(e).func_177375_c() != VertexFormatElement.EnumUsage.UV || format.func_177348_c(e).func_177369_e() != 0) continue;
            return e;
        }
        return -1;
    }

    public static int getElement(VertexFormat format, VertexFormatElement element) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (!format.func_177348_c(e).equals((Object)element)) continue;
            return e;
        }
        return -1;
    }

    public static TextureAtlasSprite getSpriteForUV(TextureMap textureMap, UV uv) {
        for (TextureAtlasSprite sprite : textureMap.field_94252_e.values()) {
            if (!MathHelper.between(sprite.func_94209_e(), uv.u, sprite.func_94212_f()) || !MathHelper.between(sprite.func_94206_g(), uv.v, sprite.func_94210_h())) continue;
            return sprite;
        }
        return textureMap.func_174944_f();
    }

    public static BakedQuad copyQuad(UnpackedBakedQuad quad) {
        return new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static Map<EnumFacing, List<BakedQuad>> sortFaceData(List<BakedQuad> quads) {
        HashMap<EnumFacing, List<BakedQuad>> faceQuadMap = new HashMap<EnumFacing, List<BakedQuad>>();
        for (BakedQuad quad : quads) {
            ArrayList<BakedQuad> faceQuads = (ArrayList<BakedQuad>)faceQuadMap.get(quad.func_178210_d());
            if (faceQuads == null) {
                faceQuads = new ArrayList<BakedQuad>();
                faceQuadMap.put(quad.func_178210_d(), faceQuads);
            }
            faceQuads.add(quad);
        }
        return faceQuadMap;
    }

    public static void fullyPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.pack((float[])unpackedData[v][e], (int[])packedData, (VertexFormat)format, (int)v, (int)e);
            }
        }
    }

    public static void fullyUnPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.unpack((int[])packedData, (float[])unpackedData[v][e], (VertexFormat)format, (int)v, (int)e);
            }
        }
    }
}

