/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.item;

import codechicken.lib.asm.ObfMapping;
import codechicken.lib.render.item.CCRenderItem;
import codechicken.lib.util.ReflectionManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="ccl-entityhook", dependencies="before:*", acceptedMinecraftVersions="[1.10.2]")
public class EntityRendererHooks {
    private static boolean hasSanitized;
    public static EntityRendererHooks instance;

    public EntityRendererHooks() {
        instance = this;
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInt(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        RenderingRegistry.registerEntityRenderingHandler(DummyEntity.class, (IRenderFactory)new IRenderFactory<DummyEntity>(){

            public Render<? super DummyEntity> createRenderFor(RenderManager manager) {
                EntityRendererHooks.sanitizeEntityRenderers(manager);
                return new Render<DummyEntity>(manager){

                    protected ResourceLocation getEntityTexture(DummyEntity entity) {
                        return null;
                    }
                };
            }
        });
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiOpenEvent event) {
        try {
            if (event.getGui() instanceof GuiModList) {
                ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)instance);
                Field field = ReflectionManager.getField(new ObfMapping("net/minecraftforge/fml/client/GuiModList", "mods", ""));
                ArrayList mods = (ArrayList)field.get(event.getGui());
                if (mods.contains(container)) {
                    mods.remove(container);
                } else {
                    FMLLog.warning((String)"CCL's Dummy mod was not found inside the mod gui list!", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to hide CCL Dummy mod from the mods gui!.", e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sanitizeEntityRenderers(RenderManager renderManager) {
        if (!hasSanitized) {
            try {
                for (Render render : renderManager.field_78729_o.values()) {
                    if (render == null) continue;
                    for (Field field : render.getClass().getDeclaredFields()) {
                        if (!field.getType().equals(RenderItem.class)) continue;
                        field.setAccessible(true);
                        field.set(render, (Object)CCRenderItem.instance());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to reflect an EntityRenderer!", e);
            }
            hasSanitized = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class DummyEntity
    extends Entity {
        public DummyEntity(World worldIn) {
            super(worldIn);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }
}

