/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.BakedModelProperties;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class PerspectiveAwareMultiModel
implements IPerspectiveAwareModel {
    private final IBakedModel baseModel;
    private final List<IBakedModel> subModels;
    private final IModelState baseState;
    private final BakedModelProperties properties;

    public PerspectiveAwareMultiModel(IBakedModel baseModel, List<IBakedModel> subModels, IModelState baseState, BakedModelProperties properties) {
        this.baseModel = baseModel;
        this.subModels = subModels;
        this.baseState = baseState;
        this.properties = properties;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (this.baseModel != null) {
            quads.addAll(this.baseModel.func_188616_a(state, side, rand));
        }
        for (IBakedModel subModel : this.subModels) {
            quads.addAll(subModel.func_188616_a(state, side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.properties.isGui3d();
    }

    public boolean func_188618_c() {
        return this.properties.isBuiltInRenderer();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.properties.getParticleTexture();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.baseState, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

