/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.fingerprint;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.fml.common.ICrashCallable;

public class FingerprintViolatedCrashCallable
implements ICrashCallable {
    private final String mod;
    private final ImmutableList<String> invalidMods;

    public FingerprintViolatedCrashCallable(String mod, List<String> invalidMods) {
        this.mod = mod;
        this.invalidMods = ImmutableList.copyOf(invalidMods);
    }

    public String getLabel() {
        return this.mod + " Invalid Fingerprint Reports";
    }

    public String call() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (String invalidMod : this.invalidMods) {
            builder.append("\n\t\t");
            builder.append(invalidMod);
            builder.append(" has an invalid fingerprint.");
        }
        return builder.toString();
    }
}

