/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.ZenTypeAssociative;
import stanhebben.zenscript.type.ZenTypeBoolObject;
import stanhebben.zenscript.type.ZenTypeByte;
import stanhebben.zenscript.type.ZenTypeByteObject;
import stanhebben.zenscript.type.ZenTypeDouble;
import stanhebben.zenscript.type.ZenTypeDoubleObject;
import stanhebben.zenscript.type.ZenTypeFloat;
import stanhebben.zenscript.type.ZenTypeFloatObject;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.ZenTypeIntObject;
import stanhebben.zenscript.type.ZenTypeLong;
import stanhebben.zenscript.type.ZenTypeLongObject;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.ZenTypeShort;
import stanhebben.zenscript.type.ZenTypeShortObject;
import stanhebben.zenscript.type.ZenTypeString;
import stanhebben.zenscript.type.ZenTypeVoid;
import stanhebben.zenscript.value.IAny;

public class TypeRegistry
implements ITypeRegistry {
    private final Map<Class, ZenType> types = new HashMap<Class, ZenType>();

    public TypeRegistry() {
        this.types.put(Boolean.TYPE, ZenType.BOOL);
        this.types.put(Byte.TYPE, ZenTypeByte.INSTANCE);
        this.types.put(Short.TYPE, ZenTypeShort.INSTANCE);
        this.types.put(Integer.TYPE, ZenTypeInt.INSTANCE);
        this.types.put(Long.TYPE, ZenTypeLong.INSTANCE);
        this.types.put(Float.TYPE, ZenTypeFloat.INSTANCE);
        this.types.put(Double.TYPE, ZenTypeDouble.INSTANCE);
        this.types.put(Void.TYPE, ZenTypeVoid.INSTANCE);
        this.types.put(Boolean.class, ZenTypeBoolObject.INSTANCE);
        this.types.put(Byte.class, ZenTypeByteObject.INSTANCE);
        this.types.put(Short.class, ZenTypeShortObject.INSTANCE);
        this.types.put(Integer.class, ZenTypeIntObject.INSTANCE);
        this.types.put(Long.class, ZenTypeLongObject.INSTANCE);
        this.types.put(Float.class, ZenTypeFloatObject.INSTANCE);
        this.types.put(Double.class, ZenTypeDoubleObject.INSTANCE);
        this.types.put(IAny.class, ZenTypeAny.INSTANCE);
        this.types.put(String.class, ZenTypeString.INSTANCE);
        this.types.put(List.class, new ZenTypeArrayBasic(ZenTypeAny.INSTANCE));
    }

    public ZenType getClassType(Class cls) {
        if (this.types.containsKey(cls)) {
            return this.types.get(cls);
        }
        if (cls.isArray()) {
            ZenTypeArrayBasic result = new ZenTypeArrayBasic(this.getType(cls.getComponentType()));
            this.types.put(cls, result);
            return result;
        }
        ZenTypeNative result = new ZenTypeNative(cls);
        this.types.put(cls, result);
        result.complete(this);
        return result;
    }

    @Override
    public ZenType getType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type raw = pType.getRawType();
            if (raw instanceof Class) {
                Class rawClass = (Class)raw;
                if (List.class.isAssignableFrom(rawClass)) {
                    return this.getListType(pType);
                }
                if (Map.class.isAssignableFrom(rawClass)) {
                    return this.getMapType(pType);
                }
                return this.getClassType(rawClass);
            }
            return this.getType(raw);
        }
        if (type instanceof Class) {
            return this.getClassType((Class)type);
        }
        return null;
    }

    private ZenType getListType(ParameterizedType type) {
        if (type.getRawType() == List.class) {
            return new ZenTypeArrayList(this.getType(type.getActualTypeArguments()[0]));
        }
        return null;
    }

    private ZenType getMapType(ParameterizedType type) {
        if (type.getRawType() == Map.class) {
            return new ZenTypeAssociative(this.getType(type.getActualTypeArguments()[1]), this.getType(type.getActualTypeArguments()[0]));
        }
        return null;
    }
}

