/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.Recipes;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.SemiFluidGenerator")
@ModOnly(value={"IC2"})
public class SemiFluidGenerator {
    @ZenMethod
    public static void addFluid(ILiquidStack liquidPerTick, int energyPerTick) {
        MineTweakerAPI.apply(new AddFluidAction(liquidPerTick.getName(), liquidPerTick.getAmount(), energyPerTick));
    }

    @ZenMethod
    public static boolean accepts(ILiquidStack liquid) {
        return Recipes.semiFluidGenerator.acceptsFluid(FluidRegistry.getFluid((String)liquid.getName()));
    }

    private static class AddFluidAction
    extends OneWayAction {
        private final String name;
        private final int liquidPerTick;
        private final int energyPerTick;

        public AddFluidAction(String name, int liquidPerTick, int energyPerTick) {
            this.name = name;
            this.liquidPerTick = liquidPerTick;
            this.energyPerTick = energyPerTick;
        }

        @Override
        public void apply() {
            Recipes.semiFluidGenerator.addFluid(this.name, this.liquidPerTick, (double)this.energyPerTick);
        }

        @Override
        public String describe() {
            return "Adding liquid " + this.name + " as semifluid fuel";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 47 * hash + this.liquidPerTick;
            hash = 47 * hash + this.energyPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFluidAction other = (AddFluidAction)obj;
            return this.name == null ? other.name == null : this.name.equals(other.name) && this.liquidPerTick == other.liquidPerTick && this.energyPerTick == other.energyPerTick;
        }
    }
}

