/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.crops;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.crops.Crop;
import minetweaker.mods.ic2.crops.SyntheticCrop;
import net.minecraftforge.common.BiomeDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.CropsConfig")
@ModOnly(value={"IC2"})
public class CropsConfig {
    @ZenMethod
    public static void addBiomeNutrientBonus(String biomeType, int nutrientBonus) {
        if (BiomeDictionary.Type.valueOf((String)biomeType) == null) {
            MineTweakerAPI.logWarning("invalid biome type: " + biomeType);
        } else if (nutrientBonus < -10 || nutrientBonus > 10) {
            MineTweakerAPI.logWarning("nutrient bonus " + nutrientBonus + " not in -10, +10 range");
        } else {
            MineTweakerAPI.apply(new AddBiomeNutrientBonusAction(biomeType, nutrientBonus));
        }
    }

    @ZenMethod
    public static void addBiomeHumidityBonus(String biomeType, int humidityBonus) {
        if (BiomeDictionary.Type.valueOf((String)biomeType) == null) {
            MineTweakerAPI.logWarning("invalid biome type: " + biomeType);
        } else if (humidityBonus < -10 || humidityBonus > 10) {
            MineTweakerAPI.logWarning("humidity bonus " + humidityBonus + " not in -10, +10 range");
        } else {
            MineTweakerAPI.apply(new AddBiomeHumidityBonusAction(biomeType, humidityBonus));
        }
    }

    @ZenMethod
    public static SyntheticCrop newCrop(String cropName, String cropOwner) {
        return new SyntheticCrop(cropName, cropOwner);
    }

    @ZenMethod
    public static void registerCrop(CropCard c) {
        MineTweakerAPI.apply(new RegisterCropCardAction(c));
    }

    public static void registerBaseSeed(IItemStack seed, CropCard c, int sz, int growth, int gain, int resist) {
        MineTweakerAPI.apply(new RegisterBaseSeedAction(seed, c, sz, growth, gain, resist));
    }

    @ZenMethod
    public static Crop getCrop(String owner, String name) {
        return new Crop(Crops.instance.getCropCard(owner, name));
    }

    @ZenMethod
    public static Crop getCrop(IItemStack seed) {
        return new Crop(Crops.instance.getCropCard(MineTweakerMC.getItemStack(seed)));
    }

    @ZenGetter(value="crops")
    public static List<Crop> getAllCrops() {
        Collection ccList = Crops.instance.getCrops();
        ArrayList<Crop> cList = new ArrayList<Crop>(ccList.size());
        cList.addAll(ccList.stream().map(Crop::new).collect(Collectors.toList()));
        return cList;
    }

    private static final class AddBiomeHumidityBonusAction
    extends OneWayAction {
        private String biomeType;
        private int humidityBonus;

        public AddBiomeHumidityBonusAction(String biomeType, int humidityBonus) {
            this.biomeType = biomeType;
            this.humidityBonus = humidityBonus;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        @Override
        public String describe() {
            return "Setting biome humidity bonus for " + this.biomeType + " biomes to " + this.humidityBonus;
        }

        @Override
        public void apply() {
            Crops.instance.addBiomehumidityBonus(BiomeDictionary.Type.valueOf((String)this.biomeType), this.humidityBonus);
        }
    }

    private static final class AddBiomeNutrientBonusAction
    extends OneWayAction {
        private String biomeType;
        private int nutrientBonus;

        public AddBiomeNutrientBonusAction(String biomeType, int nutrientBonus) {
            this.biomeType = biomeType;
            this.nutrientBonus = nutrientBonus;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        @Override
        public String describe() {
            return "Setting biome nutrient bonus for " + this.biomeType + " biomes to " + this.nutrientBonus;
        }

        @Override
        public void apply() {
            Crops.instance.addBiomenutrientsBonus(BiomeDictionary.Type.valueOf((String)this.biomeType), this.nutrientBonus);
        }
    }

    private static final class RegisterCropCardAction
    extends OneWayAction {
        private CropCard c;

        public RegisterCropCardAction(CropCard c) {
            this.c = c;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        @Override
        public String describe() {
            return "Registering crop " + this.c.getName();
        }

        @Override
        public void apply() {
            Crops.instance.registerCrop(this.c);
        }
    }

    private static final class RegisterBaseSeedAction
    extends OneWayAction {
        private IItemStack seed;
        private CropCard c;
        private int sz;
        private int growth;
        private int gain;
        private int resist;

        public RegisterBaseSeedAction(IItemStack seed, CropCard c, int sz, int growth, int gain, int resist) {
            this.seed = seed;
            this.c = c;
            this.sz = sz;
            this.growth = growth;
            this.gain = gain;
            this.resist = resist;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        @Override
        public String describe() {
            return "Registering base seed for crop " + this.c.getName();
        }

        @Override
        public void apply() {
            Crops.instance.registerBaseSeed(MineTweakerMC.getItemStack(this.seed), this.c, this.sz, this.growth, this.gain, this.resist);
        }
    }
}

