/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.feature.RevampStoneGen;

public class StoneInfoBasedGenerator
implements IWorldGenerator {
    Supplier<RevampStoneGen.StoneInfo> infoSupplier;
    WorldGenMinable generator;
    long seedXor;

    public StoneInfoBasedGenerator(Supplier<RevampStoneGen.StoneInfo> infoSupplier, IBlockState state, String name) {
        this.infoSupplier = infoSupplier;
        this.generator = new WorldGenMinable(state, infoSupplier.get().clusterSize);
        this.seedXor = name.hashCode();
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        boolean isOverworld;
        rand.setSeed(rand.nextLong() ^ this.seedXor);
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        if (!info.enabled) {
            return;
        }
        boolean bl = isOverworld = world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD;
        if (!isOverworld) {
            return;
        }
        int amount = 1;
        int chance = info.clusterRarity;
        if (info.clustersRarityPerChunk) {
            chance = 1;
            amount = info.clusterRarity;
        }
        int lower = Math.abs(info.lowerBound);
        int range = Math.abs(info.upperBound - info.lowerBound);
        if (rand.nextInt(chance) == 0) {
            for (int i = 0; i < amount; ++i) {
                int x = chunkX * 16 + rand.nextInt(16);
                int y = rand.nextInt(range) + lower;
                int z = chunkZ * 16 + rand.nextInt(16);
                this.generator.func_180709_b(world, rand, new BlockPos(x, y, z));
            }
        }
    }
}

