/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.util.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockLimestone;
import vazkii.quark.world.block.BlockMarble;
import vazkii.quark.world.block.slab.BlockLimestoneSlab;
import vazkii.quark.world.block.slab.BlockMarbleSlab;
import vazkii.quark.world.block.stairs.BlockLimestoneStairs;
import vazkii.quark.world.block.stairs.BlockMarbleStairs;
import vazkii.quark.world.world.StoneInfoBasedGenerator;

public class RevampStoneGen
extends Feature {
    public static BlockMod marble;
    public static BlockMod limestone;
    boolean enableStairsAndSlabs;
    boolean enableWalls;
    public static boolean enableMarble;
    public static boolean enableLimestone;
    public static StoneInfo graniteInfo;
    public static StoneInfo dioriteInfo;
    public static StoneInfo andesiteInfo;
    public static StoneInfo marbleInfo;
    public static StoneInfo limestoneInfo;

    @Override
    public void setupConfig() {
        this.enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true);
        this.enableWalls = this.loadPropBool("Enable walls", "", true);
        enableMarble = this.loadPropBool("Enable Marble", "", true);
        enableLimestone = this.loadPropBool("Enable Limestone", "", true);
        int defSize = 200;
        int defRarity = 50;
        int defUpper = 80;
        int defLower = 20;
        graniteInfo = this.loadStoneInfo("granite", defSize, defRarity, defUpper, defLower, true);
        dioriteInfo = this.loadStoneInfo("diorite", defSize, defRarity, defUpper, defLower, true);
        andesiteInfo = this.loadStoneInfo("andesite", defSize, defRarity, defUpper, defLower, true);
        marbleInfo = this.loadStoneInfo("marble", defSize, defRarity, defUpper, defLower, enableMarble);
        limestoneInfo = this.loadStoneInfo("limestone", defSize, defRarity, defUpper, defLower, enableLimestone);
    }

    private StoneInfo loadStoneInfo(String name, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled) {
        String category = this.configCategory + "." + name;
        StoneInfo info = new StoneInfo(category, clusterSize, clusterRarity, upperBound, lowerBound, enabled);
        return info;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableMarble) {
            marble = new BlockMarble();
            if (this.enableStairsAndSlabs) {
                BlockModSlab.initSlab((Block)marble, (int)0, (BlockModSlab)new BlockMarbleSlab(false), (BlockModSlab)new BlockMarbleSlab(true));
                BlockModStairs.initStairs((Block)marble, (int)0, (BlockStairs)new BlockMarbleStairs());
            }
            VanillaWalls.add("marble", (Block)marble, 0, this.enableWalls);
            OreDictionary.registerOre((String)"stoneMarble", (ItemStack)new ItemStack((Block)marble, 1, 0));
            OreDictionary.registerOre((String)"stoneMarblePolished", (ItemStack)new ItemStack((Block)marble, 1, 1));
            RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack((Block)marble, 4, 1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), new ItemStack((Block)marble, 1, 0)});
        }
        if (enableLimestone) {
            limestone = new BlockLimestone();
            if (this.enableStairsAndSlabs) {
                BlockModSlab.initSlab((Block)limestone, (int)0, (BlockModSlab)new BlockLimestoneSlab(false), (BlockModSlab)new BlockLimestoneSlab(true));
                BlockModStairs.initStairs((Block)limestone, (int)0, (BlockStairs)new BlockLimestoneStairs());
            }
            VanillaWalls.add("limestone", (Block)limestone, 0, this.enableWalls);
            OreDictionary.registerOre((String)"stoneLimestone", (ItemStack)new ItemStack((Block)limestone, 1, 0));
            OreDictionary.registerOre((String)"stoneLimestonePolished", (ItemStack)new ItemStack((Block)limestone, 1, 1));
            RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack((Block)limestone, 4, 1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), new ItemStack((Block)limestone, 1, 0)});
        }
        IBlockState graniteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
        IBlockState dioriteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
        IBlockState andesiteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneInfoBasedGenerator(() -> graniteInfo, graniteState, "granite"), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneInfoBasedGenerator(() -> dioriteInfo, dioriteState, "diorite"), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneInfoBasedGenerator(() -> andesiteInfo, andesiteState, "andesite"), (int)0);
        if (enableMarble) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneInfoBasedGenerator(() -> marbleInfo, marble.func_176223_P(), "marble"), (int)0);
        }
        if (enableLimestone) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneInfoBasedGenerator(() -> limestoneInfo, limestone.func_176223_P(), "limestone"), (int)0);
        }
    }

    @SubscribeEvent
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        switch (event.getType()) {
            case GRANITE: {
                if (!RevampStoneGen.graniteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case DIORITE: {
                if (!RevampStoneGen.dioriteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case ANDESITE: {
                if (!RevampStoneGen.andesiteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public boolean hasOreGenSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class StoneInfo {
        public final boolean enabled;
        public final int clusterSize;
        public final int clusterRarity;
        public final int upperBound;
        public final int lowerBound;
        public final boolean clustersRarityPerChunk;

        private StoneInfo(String category, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled) {
            this.enabled = ModuleLoader.config.getBoolean("Enabled", category, true, "") && enabled;
            this.clusterSize = ModuleLoader.config.getInt("Cluster Size", category, clusterSize, 0, Integer.MAX_VALUE, "");
            this.clusterRarity = ModuleLoader.config.getInt("Cluster Rarity", category, clusterRarity, 0, Integer.MAX_VALUE, "Out of how many chunks would one of these clusters generate");
            this.upperBound = ModuleLoader.config.getInt("Y Level Max", category, upperBound, 0, 255, "");
            this.lowerBound = ModuleLoader.config.getInt("Y Level Min", category, lowerBound, 0, 255, "");
            this.clustersRarityPerChunk = ModuleLoader.config.getBoolean("Invert Cluster Rarity", category, false, "Setting this to true will make the 'Cluster Rarity' feature be X per chunk rather than 1 per X chunks");
        }
    }
}

