/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.util.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockBasalt;
import vazkii.quark.world.block.slab.BlockBasaltSlab;
import vazkii.quark.world.block.stairs.BlockBasaltStairs;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.world.BasaltGenerator;

public class Basalt
extends Feature {
    public static BlockMod basalt;
    boolean nether;
    boolean overworld;
    int clusterSizeNether;
    int clusterSizeOverworld;
    int clusterCountNether;
    int clusterCountOverworld;
    boolean enableStairsAndSlabs;
    boolean enableWalls;

    @Override
    public void setupConfig() {
        this.nether = this.loadPropBool("Generate in nether", "", true);
        this.overworld = this.loadPropBool("Generate in overworld", "", false);
        this.clusterSizeNether = this.loadPropInt("Nether cluster size", "", 80);
        this.clusterSizeOverworld = this.loadPropInt("Overworld cluster size", "", 33);
        this.clusterCountNether = this.loadPropInt("Nether cluster count", "", 1);
        this.clusterCountOverworld = this.loadPropInt("Overworld cluster count", "", 10);
        this.enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true);
        this.enableWalls = this.loadPropBool("Enable walls", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        basalt = new BlockBasalt();
        if (this.enableStairsAndSlabs) {
            BlockModSlab.initSlab((Block)basalt, (int)0, (BlockModSlab)new BlockBasaltSlab(false), (BlockModSlab)new BlockBasaltSlab(true));
            BlockModStairs.initStairs((Block)basalt, (int)0, (BlockStairs)new BlockBasaltStairs());
        }
        VanillaWalls.add("basalt", (Block)basalt, 0, this.enableWalls);
        OreDictionary.registerOre((String)"stoneBasalt", (ItemStack)new ItemStack((Block)basalt, 1, 0));
        OreDictionary.registerOre((String)"stoneBasaltPolished", (ItemStack)new ItemStack((Block)basalt, 1, 1));
        RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack((Block)basalt, 4, 1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), new ItemStack((Block)basalt, 1, 0)});
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BasaltGenerator(this.nether, this.overworld, this.clusterSizeOverworld, this.clusterSizeNether, this.clusterCountOverworld, this.clusterCountNether), (int)0);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ItemStack blackItem = new ItemStack(Items.field_151044_h);
        if (ModuleLoader.isFeatureEnabled(Biotite.class)) {
            blackItem = new ItemStack(Biotite.biotite);
        }
        RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack((Block)basalt, 4, 0), (Object[])new Object[]{"BI", "IB", Character.valueOf('B'), new ItemStack(Blocks.field_150347_e, 1, 0), Character.valueOf('I'), blackItem});
        RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 5), (Object[])new Object[]{new ItemStack((Block)basalt), new ItemStack(Items.field_151128_bU)});
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

