/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.asm;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import vazkii.quark.base.asm.LoadingPlugin;

public class ClassTransformer
implements IClassTransformer {
    private static final String ASM_HOOKS = "vazkii/quark/base/asm/ASMHooks";
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    static int invokestaticCount;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformModelBiped(byte[] basicClass) {
        ClassTransformer.log("Transforming ModelBiped");
        MethodSignature sig = new MethodSignature("setRotationAngles", "func_78087_a", "a", "(FFFFFFLnet/minecraft/entity/Entity;)V", "(FFFFFFLrw;)V");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 177, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "updateEmotes", "(Lnet/minecraft/entity/Entity;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformRenderItem(byte[] basicClass) {
        ClassTransformer.log("Transforming RenderItem");
        MethodSignature sig1 = new MethodSignature("renderItem", "func_180454_a", "a", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V", "(Ladz;Lbyl;)V");
        MethodSignature sig2 = new MethodSignature("renderEffect", "func_180451_a", "a", "(Lnet/minecraft/client/renderer/block/model/IBakedModel;)V", "(Lbyl;)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> true, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/item/ItemStack;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> node.getOpcode() == 18 && ((LdcInsnNode)node).cst.equals(-8372020), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getRuneColor", "()I"));
            method.instructions.insertBefore(node, newInstructions);
            method.instructions.remove(node);
            return false;
        })));
        return transClass;
    }

    private static byte[] transformLayerArmorBase(byte[] basicClass) {
        ClassTransformer.log("Transforming LayerArmorBase");
        MethodSignature sig1 = new MethodSignature("renderArmorLayer", "func_188361_a", "a", "(Lnet/minecraft/entity/EntityLivingBase;FFFFFFFLnet/minecraft/inventory/EntityEquipmentSlot;)V", "(Lsf;FFFFFFFLsb;)V");
        MethodSignature sig2 = new MethodSignature("renderEnchantedGlint", "func_188364_a", "a", "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/model/ModelBase;FFFFFFF)V", "(Lbsy;Lsf;Lbju;FFFFFFF)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> node.getOpcode() == 58, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 10));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/item/ItemStack;)V"));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        try {
            if (Class.forName("optifine.OptiFineTweaker") != null) {
                ClassTransformer.log("Optifine Detected. Disabling Patch for " + sig2);
            }
        }
        catch (ClassNotFoundException e) {
            invokestaticCount = 0;
            transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> node.getOpcode() == 184, (method, node) -> {
                if (++invokestaticCount != 4 && invokestaticCount != 7) {
                    return false;
                }
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "applyRuneColor", "(FFFF)V"));
                method.instructions.insertBefore(node, newInstructions);
                method.instructions.remove(node);
                return invokestaticCount == -7;
            })));
        }
        return transClass;
    }

    private static byte[] transformEntityBoat(byte[] basicClass) {
        ClassTransformer.log("Transforming EntityBoat");
        MethodSignature sig = new MethodSignature("attackEntityFrom", "func_76986_a", "a", "(Lnet/minecraft/util/DamageSource;F)Z", "(Lrh;F)Z");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 87, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "dropBoatBanner", "(Lnet/minecraft/entity/item/EntityBoat;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformRenderBoat(byte[] basicClass) {
        ClassTransformer.log("Transforming RenderBoat");
        MethodSignature sig = new MethodSignature("doRender", "func_76986_a", "a", "(Lnet/minecraft/entity/item/EntityBoat;DDDFF)V", "(Laap;DDDFF)V");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 182 && (((MethodInsnNode)node).desc.equals("(Lnet/minecraft/entity/Entity;FFFFFF)V") || ((MethodInsnNode)node).desc.equals("(Lrw;FFFFFF)V")), (method, node) -> {
            ClassTransformer.log("Patching " + method + " in node " + node);
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 9));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderBannerOnBoat", "(Lnet/minecraft/entity/item/EntityBoat;F)V"));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformBlockPistonBase(byte[] basicClass) {
        ClassTransformer.log("Transforming BlockPistonBase");
        MethodSignature sig = new MethodSignature("doMove", "func_176319_a", "a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Z", "(Laid;Lcm;Lct;Z)Z");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 58 && ((VarInsnNode)node).var == 11, (method, node) -> {
            ClassTransformer.log("Patching " + method + " in node " + node);
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 8));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 11));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "breakStuffWithSpikes", "(Lnet/minecraft/world/World;Ljava/util/List;Ljava/util/List;Lnet/minecraft/util/EnumFacing;Z)Z"));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "size", "()I"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 8));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "size", "()I"));
            newInstructions.add((AbstractInsnNode)new InsnNode(96));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(54, 9));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 9));
            AbstractInsnNode newNode = node.getPrevious();
            while (true) {
                if (newNode.getOpcode() == 189) break;
                newNode = newNode.getPrevious();
            }
            newInstructions.add((AbstractInsnNode)new TypeInsnNode(189, ((TypeInsnNode)newNode).desc));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(58, 10));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transform(byte[] basicClass, Pair<MethodSignature, MethodAction> ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (Pair<MethodSignature, MethodAction> pair : methods) {
            ClassTransformer.log("Applying Transformation to method (" + pair.getLeft() + ")");
            didAnything |= ClassTransformer.findMethodAndTransform(node, (MethodSignature)pair.getLeft(), (MethodAction)pair.getRight());
        }
        if (didAnything) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        String funcName = sig.funcName;
        if (LoadingPlugin.runtimeDeobfEnabled) {
            funcName = sig.srgName;
        }
        for (MethodNode method : node.methods) {
            if (!method.name.equals(funcName) && !method.name.equals(sig.obfName) || !method.desc.equals(sig.funcDesc) && !method.desc.equals(sig.obfDesc)) continue;
            ClassTransformer.log("Located Method, patching...");
            boolean finish = pred.test(method);
            ClassTransformer.log("Patch result: " + finish);
            return finish;
        }
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> ClassTransformer.applyOnNode(mnode, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static void log(String str) {
        FMLLog.info((String)"[Quark ASM] %s", (Object[])new Object[]{str});
    }

    static {
        transformers.put("net.minecraft.client.model.ModelBiped", ClassTransformer::transformModelBiped);
        transformers.put("micdoodle8.mods.galacticraft.core.client.model.ModelPlayerGC", ClassTransformer::transformModelBiped);
        transformers.put("net.minecraft.client.renderer.RenderItem", ClassTransformer::transformRenderItem);
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", ClassTransformer::transformLayerArmorBase);
        transformers.put("net.minecraft.client.renderer.entity.RenderBoat", ClassTransformer::transformRenderBoat);
        transformers.put("net.minecraft.entity.item.EntityBoat", ClassTransformer::transformEntityBoat);
        transformers.put("net.minecraft.block.BlockPistonBase", ClassTransformer::transformBlockPistonBase);
        invokestaticCount = 0;
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }

    private static class MethodSignature {
        String funcName;
        String srgName;
        String obfName;
        String funcDesc;
        String obfDesc;

        public MethodSignature(String funcName, String srgName, String obfName, String funcDesc, String obfDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.obfName = obfName;
            this.funcDesc = funcDesc;
            this.obfDesc = obfDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + ", " + this.obfName + "] Descriptor " + this.funcDesc + " / " + this.obfDesc;
        }
    }
}

